/*
 * Decompiled with CFR 0.152.
 */
package com.mbs.alchemy.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.text.TextUtils;
import com.mbs.alchemy.core.T;
import com.mbs.alchemy.core.Vd;
import com.mbs.alchemy.core.hc;
import com.mbs.alchemy.core.qc;
import com.mbs.alchemy.push.AlchemyNotificationOpenResult;
import com.mbs.alchemy.push.AlchemyNotificationReceivedResult;
import com.mbs.alchemy.push.NotificationPayload;
import com.mbs.alchemy.push.gcm.e;
import java.util.Locale;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public abstract class AlchemyNotificationService
extends e {
    public static final String PROPERTY_PUSH_ICON = "com.mbs.alchemy.push.notification_icon";
    protected static final int SMALL_NOTIFICATION_MAX_CHARACTER_LIMIT = 38;
    private static final String TAG = "AlchemyNotificationService";
    public static final String KEY_PUSH_DATA = "com.mbs.alchemy.core.Data";
    public static final String KEY_ACTION = "key_action";
    public static final String ACTION_NOTIFICATION = "com.mbs.alchemy.AlchemyNotificationService";
    public static final int ALCHEMY_JOB_ID = 10010;

    public AlchemyNotificationService() {
        AlchemyNotificationService alchemyNotificationService = this;
        super(TAG);
        alchemyNotificationService.setIntentRedelivery(true);
    }

    private void pushReceive(Context context, Intent intent) {
        AlchemyNotificationReceivedResult alchemyNotificationReceivedResult;
        AlchemyNotificationReceivedResult alchemyNotificationReceivedResult2 = alchemyNotificationReceivedResult;
        alchemyNotificationReceivedResult = new AlchemyNotificationReceivedResult();
        NotificationPayload notificationPayload = alchemyNotificationService.getPushData(intent);
        if (notificationPayload == null) {
            return;
        }
        NotificationPayload notificationPayload2 = notificationPayload;
        hc.v("DAlchemyPush", "Received push data: " + notificationPayload);
        qc.m(notificationPayload2.notificationID);
        if (notificationPayload2.action != null) {
            Intent intent2;
            Bundle bundle = intent.getExtras();
            Intent intent3 = intent2;
            intent2 = new Intent();
            if (bundle != null) {
                intent3.putExtras(bundle);
            }
            Intent intent4 = intent3;
            intent3.setAction(notificationPayload.action);
            intent4.setPackage(context.getPackageName());
            context.sendBroadcast(intent4);
        }
        alchemyNotificationReceivedResult2.payload = notificationPayload;
        if (alchemyNotificationService.onPushReceive(context, alchemyNotificationReceivedResult2)) {
            return;
        }
        AlchemyNotificationService alchemyNotificationService = alchemyNotificationService.getNotification(context, notificationPayload, intent.getExtras());
        intent = null;
        if (alchemyNotificationService != null) {
            intent = alchemyNotificationService.build();
        }
        if (intent != null) {
            Vd.getInstance().a(context, (Notification)intent);
        }
    }

    private void pushDismiss(Context context, Intent intent) {
    }

    private void pushOpen(Context context, Intent intent) {
        NotificationPayload notificationPayload;
        AlchemyNotificationOpenResult alchemyNotificationOpenResult;
        AlchemyNotificationOpenResult alchemyNotificationOpenResult2 = alchemyNotificationOpenResult;
        alchemyNotificationOpenResult = new AlchemyNotificationOpenResult();
        alchemyNotificationOpenResult2.payload = notificationPayload = this.getPushData(intent);
        if (notificationPayload == null) {
            return;
        }
        qc.l(notificationPayload.notificationID);
        if (this.onPushOpen(context, alchemyNotificationOpenResult2)) {
            return;
        }
        this.handlePushData(context, notificationPayload, intent.getExtras());
    }

    private void handlePushData(Context context, NotificationPayload notificationPayload, Bundle bundle) {
        Object object = notificationPayload.uri;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)object));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
        object = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (object != null) {
            Object object2 = object;
            object2.setFlags(0x10020000);
            context.startActivity((Intent)object2);
        }
    }

    @TargetApi(value=26)
    private NotificationChannel getNotificationChannel() {
        return new NotificationChannel("alchemy", (CharSequence)"Push notifications", 4);
    }

    @TargetApi(value=26)
    private void createNotificationChannel(Context context, NotificationChannel notificationChannel) {
        ((NotificationManager)context.getSystemService("notification")).createNotificationChannel(notificationChannel);
    }

    private int getSmallIconId(Context context) {
        AlchemyNotificationService alchemyNotificationService = T.d(context);
        int n2 = 0;
        if (alchemyNotificationService != null) {
            n2 = alchemyNotificationService.getInt(PROPERTY_PUSH_ICON);
        }
        if (n2 == 0) {
            n2 = T.h();
        }
        return n2;
    }

    private Bitmap getLargeIcon(Context context) {
        return null;
    }

    private NotificationPayload getPushData(Intent intent) {
        NotificationPayload notificationPayload;
        NotificationPayload notificationPayload2 = notificationPayload;
        NotificationPayload notificationPayload3 = notificationPayload;
        try {
            notificationPayload2(new JSONObject(intent.getStringExtra(KEY_PUSH_DATA)));
            return notificationPayload3;
        }
        catch (Throwable throwable) {
            hc.e("AlchemyPush", "Can not get push data from intent.");
            return null;
        }
        catch (JSONException jSONException) {
            hc.e("AlchemyPush", "Unexpected JSONException when receiving push data: ", jSONException);
            return null;
        }
    }

    @Nullable
    private NotificationCompat.Builder getNotification(Context context, NotificationPayload object, Bundle bundle) {
        NotificationCompat.Builder builder;
        if (object == null) {
            return null;
        }
        NotificationPayload notificationPayload = object;
        object = notificationPayload.title;
        String string = notificationPayload.body;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = T.e(context);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "A new notification.";
        }
        Object[] objectArray = new Object[2];
        Object object2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = string;
        object2 = String.format(Locale.getDefault(), "%s: %s", object2);
        Random random = new Random();
        int n2 = random.nextInt();
        Bundle bundle2 = bundle;
        String string2 = context.getPackageName();
        bundle = this.getContentIntent(bundle, string2);
        bundle = PendingIntent.getBroadcast((Context)context, (int)n2, (Intent)bundle, (int)0x8000000);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)random.nextInt(), (Intent)this.getDeleteIntent(bundle2, string2), (int)0x8000000);
        string2 = null;
        if (Build.VERSION.SDK_INT >= 26) {
            string2 = this.getNotificationChannel();
            this.createNotificationChannel(context, (NotificationChannel)string2);
            string2 = string2.getId();
        }
        NotificationCompat.Builder builder2 = builder;
        builder2(context, string2);
        builder.setContentTitle((CharSequence)object).setContentText((CharSequence)string).setTicker((CharSequence)object2).setSmallIcon(this.getSmallIconId(context)).setLargeIcon(this.getLargeIcon(context)).setContentIntent((PendingIntent)bundle).setDeleteIntent(pendingIntent).setAutoCancel(true).setDefaults(-1).setWhen(System.currentTimeMillis()).setPriority(2);
        if (Build.VERSION.SDK_INT > 16) {
            builder2.setShowWhen(true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            builder2.setCategory("status");
        }
        if (string.length() > 38) {
            builder2.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string));
        }
        return builder2;
    }

    private Intent getContentIntent(Bundle bundle, String string) {
        Intent intent;
        AlchemyNotificationService alchemyNotificationService = intent;
        alchemyNotificationService("com.mbs.alchemy.push.intent.OPEN");
        alchemyNotificationService.putExtras(bundle);
        intent.setPackage(string);
        return intent;
    }

    private Intent getDeleteIntent(Bundle bundle, String string) {
        Intent intent;
        AlchemyNotificationService alchemyNotificationService = intent;
        alchemyNotificationService("com.mbs.alchemy.push.intent.DELETE");
        alchemyNotificationService.putExtras(bundle);
        intent.setPackage(string);
        return intent;
    }

    @Override
    public int onStartCommand(@Nullable Intent intent, int n2, int n3) {
        hc.d(TAG, "onStartCommand");
        return super.onStartCommand(intent, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        block11: {
            hc.d(TAG, "onHandleWork");
            try {
                int n2;
                block13: {
                    String string;
                    block12: {
                        string = intent.getStringExtra(KEY_ACTION);
                        if (string == null) break block11;
                        n2 = -1;
                        int n3 = string.hashCode();
                        if (n3 == -571909765) break block12;
                        if (n3 != 11435666) {
                            if (n3 == 2074863603 && string.equals("com.mbs.alchemy.push.intent.DELETE")) {
                                n2 = 1;
                            }
                            break block13;
                        } else if (string.equals("com.mbs.alchemy.push.intent.OPEN")) {
                            n2 = 2;
                        }
                        break block13;
                    }
                    if (string.equals("com.mbs.alchemy.push.intent.RECEIVE")) {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    if (n2 != 1) {
                        if (n2 == 2) {
                            AlchemyNotificationService alchemyNotificationService = this;
                            alchemyNotificationService.pushOpen((Context)alchemyNotificationService, intent);
                        }
                        break block11;
                    }
                    AlchemyNotificationService alchemyNotificationService = this;
                    alchemyNotificationService.pushDismiss((Context)alchemyNotificationService, intent);
                    break block11;
                }
                AlchemyNotificationService alchemyNotificationService = this;
                alchemyNotificationService.pushReceive((Context)alchemyNotificationService, intent);
            }
            catch (Throwable throwable) {
                WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
                throw throwable;
            }
            catch (Exception exception) {}
        }
        WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
    }

    protected abstract boolean onPushReceive(Context var1, AlchemyNotificationReceivedResult var2);

    protected abstract boolean onPushOpen(Context var1, AlchemyNotificationOpenResult var2);
}

