/*
 * Decompiled with CFR 0.152.
 */
package com.mbs.alchemy.core;

import android.os.Parcel;
import android.os.Parcelable;
import com.mbs.alchemy.core.Ed;
import com.mbs.alchemy.core.Oe;
import com.mbs.alchemy.core.Pe;
import java.util.Locale;

public class Fd
implements Parcelable {
    public static final Parcelable.Creator<Fd> CREATOR = new Ed();
    static double Oc = 6371.0;
    static double Pc = 3958.8;
    private double Qc = 0.0;
    private double Rc = 0.0;

    public Fd() {
    }

    public Fd(double d2, double d3) {
        this.setLatitude(d2);
        this.setLongitude(d3);
    }

    Fd(Parcel parcel, Oe oe2) {
        this.setLatitude(parcel.readDouble());
        this.setLongitude(parcel.readDouble());
    }

    public double getLatitude() {
        return this.Qc;
    }

    public void setLatitude(double d2) {
        if (!(d2 > 90.0) && !(d2 < -90.0)) {
            this.Qc = d2;
            return;
        }
        throw new IllegalArgumentException("Latitude must be within the range (-90.0, 90.0).");
    }

    public double getLongitude() {
        return this.Rc;
    }

    public void setLongitude(double d2) {
        if (!(d2 > 180.0) && !(d2 < -180.0)) {
            this.Rc = d2;
            return;
        }
        throw new IllegalArgumentException("Longitude must be within the range (-180.0, 180.0).");
    }

    public double a(Fd fd2) {
        double d2 = Math.PI / 180;
        double d3 = this.Qc * d2;
        double d4 = this.Rc * d2;
        double d5 = fd2.getLatitude() * d2;
        double d6 = fd2.getLongitude() * d2;
        d6 = d4 - d6;
        double d7 = Math.sin((d3 - d5) / 2.0);
        d6 = Math.sin(d6 / 2.0);
        d6 = d7 * d7 + Math.cos(d3) * Math.cos(d5) * d6 * d6;
        return Math.asin(Math.sqrt(Math.min(1.0, d6))) * 2.0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Fd) {
            if (object == this) {
                return true;
            }
            return ((Fd)(object = (Fd)object)).getLatitude() == this.Qc && ((Fd)object).getLongitude() == this.Rc;
        }
        return false;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.Qc;
        objectArray[1] = this.Rc;
        return String.format(Locale.US, "ParseGeoPoint[%.6f,%.6f]", objectArray2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        this.b(parcel, Pe.get());
    }

    void b(Parcel parcel, Pe pe2) {
        parcel.writeDouble(this.Qc);
        parcel.writeDouble(this.Rc);
    }
}

