/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.transform;

import com.mayabot.nlp.Mynlp;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.collection.ahocorasick.AhoCoraickDoubleArrayTrieBuilder;
import com.mayabot.nlp.collection.ahocorasick.AhoCorasickDoubleArrayTrie;
import com.mayabot.nlp.utils.CharSourceLineReader;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;

public abstract class BaseTransformDictionary {
    public static final String rsVersion = "1.0.0";
    AhoCorasickDoubleArrayTrie<String> trie;

    public abstract TreeMap<String, String> loadDictionary();

    TreeMap<String, String> loadFromResouce(String resourceName) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            Mynlp mynlp = Mynlps.get();
            mynlp.getEnv().registeResourceMissing("transform", (rsName, env) -> {
                File file;
                return (rsName.equals("ts-dict/s2t.txt") || rsName.equals("ts-dict/t2s.txt")) && (file = env.download("mynlp-resource-transform-1.0.0.jar")) != null && file.exists();
            });
            CharSourceLineReader charSourceLineReader = mynlp.getEnv().loadResource(resourceName).openLineReader();
            charSourceLineReader.forEachRemaining(line -> {
                String[] split = line.split("=");
                if (split.length == 2) {
                    treeMap.put(split[0], split[1]);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return treeMap;
    }

    public BaseTransformDictionary() {
        AhoCoraickDoubleArrayTrieBuilder builder = new AhoCoraickDoubleArrayTrieBuilder();
        this.trie = builder.build(this.loadDictionary());
    }

    public String transform(String text) {
        return this.transform(text.toCharArray());
    }

    public String transform(char[] charArray) {
        String[] wordNet = new String[charArray.length];
        int[] lengthNet = new int[charArray.length];
        this.trie.parseText(charArray, (begin, end, value) -> {
            int length = end - begin;
            if (length > lengthNet[begin]) {
                wordNet[begin] = value;
                lengthNet[begin] = length;
            }
        });
        StringBuilder sb = new StringBuilder(charArray.length);
        int offset = 0;
        while (offset < wordNet.length) {
            if (wordNet[offset] == null) {
                sb.append(charArray[offset]);
                ++offset;
                continue;
            }
            sb.append(wordNet[offset]);
            offset += lengthNet[offset];
        }
        return sb.toString();
    }
}

