/*
 * Decompiled with CFR 0.152.
 */
package com.mavericklabs.otp_reader;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.mavericklabs.otp_reader.OtpReaderListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmsBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "SmsBroadcastReceiver";
    OtpReaderListener otpReceiveInterface = null;

    public void setOnOtpListeners(OtpReaderListener otpReceiveInterface) {
        this.otpReceiveInterface = otpReceiveInterface;
    }

    public void onReceive(Context context, Intent intent) {
        Log.d((String)TAG, (String)"onReceive: ");
        if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
            Bundle extras = intent.getExtras();
            Status mStatus = (Status)extras.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
            switch (mStatus.getStatusCode()) {
                case 0: {
                    String message = (String)extras.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                    Log.d((String)TAG, (String)("onReceive: failure " + message));
                    if (this.otpReceiveInterface == null) break;
                    this.otpReceiveInterface.onOtpReceived(this.parseCode(message.replace(" ", "")));
                    break;
                }
                case 15: {
                    Log.d((String)TAG, (String)"onReceive: failure");
                    if (this.otpReceiveInterface == null) break;
                    this.otpReceiveInterface.onOtpTimeout();
                }
            }
        }
    }

    public String parseCode(String message) {
        Pattern p = Pattern.compile("(|^)\\d{6}");
        Matcher m = p.matcher(message);
        String code = "";
        while (m.find()) {
            code = m.group(0);
        }
        return code;
    }
}

