/*
 * Decompiled with CFR 0.152.
 */
package com.mavericklabs.customradiobutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.RadioButton;
import androidx.core.content.ContextCompat;
import com.mavericklabs.customradiobutton.R;

public class CustomRadioButton
extends RadioButton {
    private final int LEFT = 1;
    private final int MIDDLE = 2;
    private final int RIGHT = 3;
    private int buttonType;

    public CustomRadioButton(Context context) {
        super(context);
        this.init(null, 0);
    }

    public CustomRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public CustomRadioButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CustomRadioButton, defStyle, 0);
        this.buttonType = a.getInt(R.styleable.CustomRadioButton_radioButtonType, 1);
        this.setTextSize(2, 16.0f);
        int padding = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.setButtonDrawable(null);
        this.setPadding(padding, 0, padding, 0);
        this.setGravity(17);
        this.setTextColor(this.getResources().getColorStateList(R.color.rb_text_view_selector));
        if (this.buttonType == 1) {
            this.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.left_radio_button_selector));
        } else if (this.buttonType == 2) {
            this.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.middle_radio_button_selector));
        } else {
            this.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.right_radio_button_selector));
        }
        a.recycle();
    }
}

