package com.mavericklabs.customradiobutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;

import androidx.appcompat.widget.AppCompatRadioButton;
import androidx.core.content.ContextCompat;

public class CustomRadioButton extends AppCompatRadioButton {
    private final int LEFT = 1;
    private final int MIDDLE = 2;
    private final int RIGHT = 3;
    private int buttonType;

    public CustomRadioButton(Context context) {
        super(context);
        init(null, 0);
    }

    public CustomRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs, 0);
    }

    public CustomRadioButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        // Load attributes
        final TypedArray a = getContext().obtainStyledAttributes(
                attrs, R.styleable.CustomRadioButton, defStyle, 0);
        buttonType = a.getInt(R.styleable.CustomRadioButton_radioButtonType, LEFT);
        setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
        int padding = (int) TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_DIP,
                8,
                getContext().getResources().getDisplayMetrics());
        setPadding(padding, padding, padding, padding);
        setGravity(Gravity.CENTER);
        setTextColor(getResources().getColorStateList(R.color.rb_text_view_selector));
        setButtonDrawable(null);
        if (buttonType == LEFT) {
            setBackground(ContextCompat.getDrawable(getContext(), R.drawable.left_radio_button_selector));
        } else if (buttonType == MIDDLE) {
            setBackground(ContextCompat.getDrawable(getContext(), R.drawable.middle_radio_button_selector));
        } else {
            setBackground(ContextCompat.getDrawable(getContext(), R.drawable.right_radio_button_selector));
        }
        a.recycle();
    }
}
