/*
 * Decompiled with CFR 0.152.
 */
package com.mauiie.aech;

import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.widget.Toast;
import com.mauiie.aech.AECHConfiguration;
import com.mauiie.aech.AECHFileWriter;
import com.mauiie.aech.R;
import com.mauiie.aech.utils.LogUtil;
import java.io.File;

public class AECrashHandler
implements Thread.UncaughtExceptionHandler {
    private static AECrashHandler ourInstance = null;
    private Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private Context mContext;
    private AECHConfiguration config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AECrashHandler getInstance(Context appContext, AECHConfiguration config) {
        Class<AECrashHandler> clazz = AECrashHandler.class;
        synchronized (AECrashHandler.class) {
            if (ourInstance == null) {
                ourInstance = new AECrashHandler();
                AECrashHandler.ourInstance.defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                AECrashHandler.ourInstance.mContext = appContext;
                AECrashHandler.ourInstance.config = config;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ourInstance;
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && null != this.defaultUncaughtExceptionHandler) {
            this.defaultUncaughtExceptionHandler.uncaughtException(thread, ex);
        } else {
            SystemClock.sleep((long)3000L);
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (null == ex) {
            return false;
        }
        if (null == this.config || !this.config.isReportToServer() && !this.config.isSaveToLocal()) {
            return false;
        }
        this.sendCrashToServer(ex);
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Toast.makeText((Context)AECrashHandler.this.mContext, (CharSequence)AECrashHandler.this.mContext.getResources().getString(R.string.error_toast), (int)0).show();
                Looper.loop();
            }
        }.start();
        this.saveCrashToLocal(ex);
        return true;
    }

    private void saveCrashToLocal(Throwable ex) {
        LogUtil.d("saveCrashToLocal");
        if (this.config.isSaveToLocal()) {
            String localFolderPath = this.config.getLocalFolderPath();
            if (null != localFolderPath && localFolderPath.length() > 2) {
                File file = new File(localFolderPath);
                if (file.exists() && file.isDirectory()) {
                    AECHFileWriter.getInstance(this.mContext).writeEx2File(ex, localFolderPath);
                } else {
                    AECHFileWriter.getInstance(this.mContext).writeEx2File(ex);
                }
            } else {
                AECHFileWriter.getInstance(this.mContext).writeEx2File(ex);
            }
        }
    }

    private void sendCrashToServer(Throwable ex) {
        LogUtil.d("sendCrashToServer");
        if (this.config.isReportToServer() && null != this.config) {
            this.config.getReporter().report(ex);
        }
    }
}

