/*
 * Decompiled with CFR 0.152.
 */
package com.mauiie.aech;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import com.mauiie.aech.utils.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;

public class AECHFileWriter {
    private static AECHFileWriter ourInstance = null;
    private static Context mContext;
    private StorageStrategy storageState;
    private String crashStorePath;
    private String directory = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AECHFileWriter getInstance(Context context) {
        Class<AECHFileWriter> clazz = AECHFileWriter.class;
        synchronized (AECHFileWriter.class) {
            if (ourInstance == null) {
                ourInstance = new AECHFileWriter(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourInstance;
        }
    }

    private AECHFileWriter(Context context) {
        mContext = context;
        this.storageState = StorageStrategy.STRATEGY_NO_RECOMMEND;
        this.crashStorePath = this.judgePath();
    }

    private String judgePath() {
        String appAbsolutePath = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            try {
                appAbsolutePath = mContext.getExternalFilesDir("crash").toString();
                this.storageState = StorageStrategy.STRATEGY_EXTERNAL;
            }
            catch (NullPointerException e) {
                appAbsolutePath = mContext.getDir("crash", 0).toString();
                this.storageState = StorageStrategy.STRATEGY_NO_RECOMMEND;
            }
        } else {
            appAbsolutePath = mContext.getDir("crash", 0).toString();
            this.storageState = StorageStrategy.STRATEGY_INTERNAL;
        }
        return appAbsolutePath;
    }

    public void writeEx2File(Throwable throwable) {
        this.writeEx2File(throwable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEx2File(Throwable throwable, String intentPath) {
        LogUtil.d("writeEx2File   " + this.crashStorePath);
        this.directory = intentPath;
        if (null == this.directory || this.directory.length() < 2) {
            this.directory = this.crashStorePath;
        }
        if (throwable == null) {
            return;
        }
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(printWriter);
        try (PrintWriter printWriter = new PrintWriter(writer);){
            Throwable cause = throwable.getCause();
            cause.printStackTrace(printWriter);
        }
        final String result = writer.toString();
        final String message = throwable.getMessage();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String fileName = AECHFileWriter.this.obtainFileName();
                File file = new File(AECHFileWriter.this.directory, fileName);
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                        file.setWritable(Boolean.TRUE);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file, true);
                    fos.write(("=>date = " + AECHFileWriter.getPrintToTextTime() + "\r\n" + "=>msgs = " + message).getBytes());
                    fos.write(result.getBytes());
                    fos.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private String obtainFileName() {
        return "crash_" + AECHFileWriter.getPrintToFileTime() + ".log";
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getPrintToFileTime() {
        String date = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        date = sdf.format(System.currentTimeMillis());
        return date;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getPrintToTextTime() {
        String date = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        date = sdf.format(System.currentTimeMillis());
        return date;
    }

    private static enum StorageStrategy {
        STRATEGY_INTERNAL,
        STRATEGY_EXTERNAL,
        STRATEGY_NONE,
        STRATEGY_NO_RECOMMEND;

    }
}

