/*
 * Decompiled with CFR 0.152.
 */
package com.mauiie.aech;

public class AECHConfiguration {
    private boolean saveToLocal;
    private boolean reportToServer;
    private IAECHReporter reporter;
    private String localFolderPath = null;

    public boolean isSaveToLocal() {
        return this.saveToLocal;
    }

    public boolean isReportToServer() {
        return this.reportToServer;
    }

    public IAECHReporter getReporter() {
        return this.reporter;
    }

    public String getLocalFolderPath() {
        return this.localFolderPath;
    }

    private AECHConfiguration(Builder builder) {
        this.reporter = builder.reporter;
        this.saveToLocal = builder.saveToLocal;
        this.reportToServer = builder.reportToServer;
        this.localFolderPath = builder.localFolderPath;
    }

    public static interface IAECHReporter {
        public void report(Throwable var1);
    }

    public static class Builder {
        private boolean saveToLocal = true;
        private boolean reportToServer = false;
        private IAECHReporter reporter = null;
        private String localFolderPath = null;

        public Builder setLocalFolderPath(String localFolderPath) {
            this.localFolderPath = localFolderPath;
            return this;
        }

        public Builder setSaveToLocal(boolean saveToLocal) {
            this.saveToLocal = saveToLocal;
            return this;
        }

        public Builder setReportToServer(boolean reportToServer) {
            this.reportToServer = reportToServer;
            return this;
        }

        public Builder setReporter(IAECHReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public AECHConfiguration build() {
            AECHConfiguration configuration = new AECHConfiguration(this);
            return configuration;
        }
    }
}

