/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.transformers;

import android.support.v4.view.ViewPager;
import android.view.View;
import com.matthewtamlin.sliding_intro_screen_library.transformers.ChildViewCache;
import java.util.HashMap;

public class MultiViewParallaxTransformer
implements ViewPager.PageTransformer {
    private final HashMap<Integer, Float> parallaxFactors = new HashMap();
    private final HashMap<View, ChildViewCache> savedViews = new HashMap();

    public void transformPage(View page, float position) {
        boolean pageIsScrolling;
        boolean pageIsSelected = position == 0.0f;
        boolean bl = pageIsScrolling = -1.0f < position && position < 1.0f;
        if (pageIsSelected) {
            page.invalidate();
        } else if (pageIsScrolling) {
            for (Integer id2 : this.parallaxFactors.keySet()) {
                View viewToTransform = this.getViewToTransform(page, id2);
                if (viewToTransform == null) continue;
                float parallaxFactor = this.parallaxFactors.get(id2).floatValue();
                float nominalDisplacement = (float)(page.getWidth() / 2) * position;
                float modifiedDisplacement = nominalDisplacement * (parallaxFactor - 1.0f);
                viewToTransform.setTranslationX(modifiedDisplacement);
            }
        }
    }

    public MultiViewParallaxTransformer withParallaxView(int id2, float parallaxFactor) {
        this.parallaxFactors.put(id2, Float.valueOf(parallaxFactor));
        return this;
    }

    public MultiViewParallaxTransformer withoutParallaxView(int id2) {
        this.parallaxFactors.remove(id2);
        return this;
    }

    private View getViewToTransform(View rootView, int id2) {
        if (rootView == null) {
            throw new IllegalArgumentException("rootView cannot be null");
        }
        if (!this.savedViews.containsKey(rootView)) {
            this.savedViews.put(rootView, new ChildViewCache(rootView));
        }
        return this.savedViews.get(rootView).getChildView(id2);
    }
}

