/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.transformers;

import android.view.View;
import java.util.HashMap;

class ChildViewCache {
    private final View parentView;
    private final HashMap<Integer, View> cachedViews = new HashMap();

    public ChildViewCache(View parentView) {
        if (parentView == null) {
            throw new IllegalArgumentException("parentView cannot be null");
        }
        this.parentView = parentView;
    }

    public final View getChildView(int id2) {
        if (!this.cachedViews.containsKey(id2)) {
            this.cachedViews.put(id2, this.parentView.findViewById(id2));
        }
        return this.cachedViews.get(id2);
    }

    public View getParentView() {
        return this.parentView;
    }

    public void reset() {
        this.cachedViews.clear();
    }
}

