/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.pages;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.matthewtamlin.sliding_intro_screen_library.R;

public class ParallaxPage
extends Fragment {
    private static final String TAG = "[ParallaxPage]";
    private FrameLayout rootView;
    private ImageView frontImageHolder;
    private ImageView backImageHolder;
    private TextView textHolder;
    private Bitmap frontImage = null;
    private Bitmap backImage = null;
    private CharSequence text = null;

    public static ParallaxPage newInstance() {
        return new ParallaxPage();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = (FrameLayout)inflater.inflate(R.layout.fragment_parallax_page, container, false);
        this.frontImageHolder = (ImageView)this.rootView.findViewById(R.id.page_fragment_imageHolderFront);
        this.backImageHolder = (ImageView)this.rootView.findViewById(R.id.page_fragment_imageHolderBack);
        this.textHolder = (TextView)this.rootView.findViewById(R.id.page_fragment_textHolder);
        this.reflectParametersInView();
        return this.rootView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    private void reflectParametersInView() {
        if (this.frontImageHolder != null) {
            this.frontImageHolder.setImageBitmap(null);
            this.frontImageHolder.setImageBitmap(this.frontImage);
        }
        if (this.backImageHolder != null) {
            this.backImageHolder.setImageBitmap(null);
            this.backImageHolder.setImageBitmap(this.backImage);
        }
        if (this.textHolder != null) {
            this.textHolder.setText(null);
            this.textHolder.setText(this.text);
        }
    }

    public void setFrontImage(Bitmap frontImage) {
        this.frontImage = frontImage;
        this.reflectParametersInView();
    }

    public Bitmap getFrontImage() {
        return this.frontImage;
    }

    public View getFrontImageHolder() {
        return this.frontImageHolder;
    }

    public void setBackImage(Bitmap backImage) {
        this.backImage = backImage;
        this.reflectParametersInView();
    }

    public Bitmap getBackImage() {
        return this.backImage;
    }

    public View getBackImageHolder() {
        return this.backImageHolder;
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.reflectParametersInView();
    }

    public CharSequence getText() {
        return this.text;
    }

    public View getTextHolder() {
        return this.textHolder;
    }
}

