/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.core;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class LockableViewPager
extends ViewPager {
    private static final String TAG = "[LockableViewPager]";
    private LockMode lockMode = LockMode.UNLOCKED;

    public LockableViewPager(Context context) {
        super(context);
    }

    public LockableViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setLockMode(LockMode lockMode) {
        if (lockMode == null) {
            throw new IllegalArgumentException("lockMode cannot be null");
        }
        this.lockMode = lockMode;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return !this.lockMode.allowsTouch() || super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return !this.lockMode.allowsTouch() || super.onTouchEvent(ev);
    }

    public void fakeDragBy(float xOffset) {
        if (this.lockMode.allowsCommands()) {
            super.fakeDragBy(xOffset);
        }
    }

    public void setCurrentItem(int item) {
        if (this.lockMode.allowsCommands()) {
            super.setCurrentItem(item);
        }
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.lockMode.allowsCommands()) {
            super.setCurrentItem(item, smoothScroll);
        }
    }

    public static enum LockMode {
        TOUCH_LOCKED(false, true),
        COMMAND_LOCKED(true, false),
        FULLY_LOCKED(false, false),
        UNLOCKED(true, true);

        private final boolean allowsTouch;
        private final boolean allowsCommands;

        private LockMode(boolean allowsTouch, boolean allowsCommands) {
            this.allowsTouch = allowsTouch;
            this.allowsCommands = allowsCommands;
        }

        public final boolean allowsTouch() {
            return this.allowsTouch;
        }

        public final boolean allowsCommands() {
            return this.allowsCommands;
        }
    }
}

