/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.core;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.matthewtamlin.android_utilities_library.collections.ArrayListWithCallbacks;
import com.matthewtamlin.android_utilities_library.helpers.ColorHelper;
import com.matthewtamlin.android_utilities_library.helpers.StatusBarHelper;
import com.matthewtamlin.sliding_intro_screen_library.R;
import com.matthewtamlin.sliding_intro_screen_library.background.BackgroundManager;
import com.matthewtamlin.sliding_intro_screen_library.buttons.AnimatorFactory;
import com.matthewtamlin.sliding_intro_screen_library.buttons.FadeAnimatorFactory;
import com.matthewtamlin.sliding_intro_screen_library.buttons.IntroButton;
import com.matthewtamlin.sliding_intro_screen_library.buttons.IntroButtonAccessor;
import com.matthewtamlin.sliding_intro_screen_library.core.LockableViewPager;
import com.matthewtamlin.sliding_intro_screen_library.core.PageAdapter;
import com.matthewtamlin.sliding_intro_screen_library.indicators.DotIndicator;
import com.matthewtamlin.sliding_intro_screen_library.indicators.SelectionIndicator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public abstract class IntroActivity
extends AppCompatActivity {
    private static final String TAG = "[IntroActivity]";
    private static final String STATE_KEY_CURRENT_PAGE_INDEX = "current page index";
    private static final int DEFAULT_CURRENT_PAGE_INDEX = 0;
    private static final IntroButton.Appearance DEFAULT_LEFT_BUTTON_APPEARANCE = IntroButton.Appearance.TEXT_ONLY;
    private static final IntroButton.Appearance DEFAULT_RIGHT_BUTTON_APPEARANCE = IntroButton.Appearance.ICON_ONLY;
    private static final IntroButton.Appearance DEFAULT_FINAL_BUTTON_APPEARANCE = IntroButton.Appearance.TEXT_ONLY;
    private static final CharSequence DEFAULT_FINAL_BUTTON_TEXT = "DONE";
    private static final int BUTTON_ANIMATION_DURATION_MS = 150;
    private final IntroButton.Behaviour DEFAULT_LEFT_BUTTON_BEHAVIOUR = new IntroButton.GoToLastPage();
    private final IntroButton.Behaviour DEFAULT_RIGHT_BUTTON_BEHAVIOUR = new IntroButton.GoToNextPage();
    private RelativeLayout rootView;
    private LockableViewPager viewPager;
    private View horizontalDivider;
    private FrameLayout progressIndicatorWrapper;
    private SelectionIndicator progressIndicator;
    private boolean progressIndicatorAnimationsEnabled = true;
    private IntroButton leftButton;
    private IntroButton rightButton;
    private IntroButton finalButton;
    private boolean leftButtonDisabled = false;
    private boolean rightButtonDisabled = false;
    private boolean finalButtonDisabled = false;
    private boolean disableLeftButtonOnLastPage = true;
    private AnimatorFactory buttonAnimatorFactory;
    private final HashMap<IntroButton, Animator> buttonAnimations = new HashMap();
    private final ArrayListWithCallbacks<Fragment> pages = new ArrayListWithCallbacks();
    private final PageAdapter adapter = new PageAdapter(this.getSupportFragmentManager(), this.pages);
    private BackgroundManager backgroundManager = null;
    private final ViewPager.OnPageChangeListener pageChangeListenerDelegate = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (IntroActivity.this.backgroundManager != null) {
                IntroActivity.this.backgroundManager.updateBackground((View)IntroActivity.this.rootView, position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            IntroActivity.this.reflectMemberVariablesInAllButtons();
            if (IntroActivity.this.progressIndicator != null) {
                IntroActivity.this.progressIndicator.setSelectedItem(position, IntroActivity.this.progressIndicatorAnimationsEnabled);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_intro);
        this.bindViews();
        this.initialiseNavigationButtons();
        this.buttonAnimatorFactory = this.generateButtonAnimatorFactory();
        this.pages.addAll(this.generatePages(savedInstanceState));
        this.viewPager.addOnPageChangeListener(this.pageChangeListenerDelegate);
        this.initialiseViewPager(savedInstanceState);
        this.progressIndicator = new DotIndicator((Context)this);
        this.regenerateProgressIndicator();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        boolean lastPage;
        super.onWindowFocusChanged(hasFocus);
        this.reflectMemberVariablesInAllButtons();
        boolean bl = lastPage = this.getIndexOfCurrentPage() + 1 == this.pages.size();
        if (hasFocus && !lastPage) {
            Animator finalButtonAnimator = this.buttonAnimatorFactory.newFinalButtonDisappearAnimator((View)this.finalButton);
            finalButtonAnimator.start();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_KEY_CURRENT_PAGE_INDEX, this.viewPager.getCurrentItem());
    }

    public void onBackPressed() {
        if (this.viewPager.getCurrentItem() == 0 || !this.getPagingLockMode().allowsCommands()) {
            super.onBackPressed();
        } else {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() - 1);
        }
    }

    private void bindViews() {
        this.rootView = (RelativeLayout)this.findViewById(R.id.intro_activity_root);
        this.horizontalDivider = this.findViewById(R.id.intro_activity_horizontalDivider);
        this.viewPager = (LockableViewPager)this.findViewById(R.id.intro_activity_viewPager);
        this.progressIndicatorWrapper = (FrameLayout)this.findViewById(R.id.intro_activity_progressIndicatorHolder);
        this.leftButton = (IntroButton)this.findViewById(R.id.intro_activity_leftButton);
        this.rightButton = (IntroButton)this.findViewById(R.id.intro_activity_rightButton);
        this.finalButton = (IntroButton)this.findViewById(R.id.intro_activity_finalButton);
    }

    private void initialiseViewPager(Bundle savedInstanceState) {
        int pageIndex = savedInstanceState == null ? 0 : savedInstanceState.getInt(STATE_KEY_CURRENT_PAGE_INDEX, 0);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.setCurrentItem(pageIndex);
        if (this.backgroundManager != null) {
            this.backgroundManager.updateBackground((View)this.rootView, pageIndex, 0.0f);
        }
    }

    private void initialiseNavigationButtons() {
        this.leftButton.setBehaviour(this.DEFAULT_LEFT_BUTTON_BEHAVIOUR);
        this.leftButton.setAppearance(DEFAULT_LEFT_BUTTON_APPEARANCE);
        this.leftButton.setActivity(this);
        this.rightButton.setBehaviour(this.DEFAULT_RIGHT_BUTTON_BEHAVIOUR);
        this.rightButton.setAppearance(DEFAULT_RIGHT_BUTTON_APPEARANCE);
        this.rightButton.setActivity(this);
        this.finalButton.setBehaviour(this.generateFinalButtonBehaviour());
        this.finalButton.setAppearance(DEFAULT_FINAL_BUTTON_APPEARANCE);
        this.finalButton.setText(DEFAULT_FINAL_BUTTON_TEXT, null);
        this.finalButton.setActivity(this);
    }

    private void reflectMemberVariablesInAllButtons() {
        this.reflectMemberVariablesInLeftButton();
        this.reflectMemberVariablesInRightButton();
        this.reflectMemberVariablesInFinalButton();
    }

    private void reflectMemberVariablesInLeftButton() {
        boolean shouldUpdateButton;
        boolean lastPageReached = this.viewPager.getCurrentItem() + 1 == this.pages.size();
        boolean buttonShouldBeInvisible = lastPageReached && this.disableLeftButtonOnLastPage || this.leftButtonDisabled;
        boolean buttonIsCurrentlyInvisible = this.leftButton.getVisibility() == 4;
        boolean bl = shouldUpdateButton = buttonShouldBeInvisible != buttonIsCurrentlyInvisible;
        if (shouldUpdateButton) {
            Animator buttonAnimator;
            Animator animator = buttonAnimator = buttonShouldBeInvisible ? this.buttonAnimatorFactory.newLeftButtonDisappearAnimator((View)this.leftButton) : this.buttonAnimatorFactory.newLeftButtonAppearAnimator((View)this.leftButton);
            if (buttonShouldBeInvisible) {
                this.disableButton(buttonAnimator, this.leftButton);
            } else {
                this.enableButton(buttonAnimator, this.leftButton);
            }
        }
    }

    private void reflectMemberVariablesInRightButton() {
        boolean shouldUpdateButton;
        boolean lastPageReached = this.viewPager.getCurrentItem() + 1 == this.pages.size();
        boolean buttonShouldBeInvisible = lastPageReached || this.rightButtonDisabled;
        boolean buttonIsCurrentlyInvisible = this.rightButton.getVisibility() == 4;
        boolean bl = shouldUpdateButton = buttonShouldBeInvisible != buttonIsCurrentlyInvisible;
        if (shouldUpdateButton) {
            Animator buttonAnimator;
            Animator animator = buttonAnimator = buttonShouldBeInvisible ? this.buttonAnimatorFactory.newRightButtonDisappearAnimator((View)this.rightButton) : this.buttonAnimatorFactory.newRightButtonAppearAnimator((View)this.rightButton);
            if (buttonShouldBeInvisible) {
                this.disableButton(buttonAnimator, this.rightButton);
            } else {
                this.enableButton(buttonAnimator, this.rightButton);
            }
        }
    }

    private void reflectMemberVariablesInFinalButton() {
        boolean shouldUpdateButton;
        boolean lastPageReached = this.viewPager.getCurrentItem() + 1 == this.pages.size();
        boolean buttonShouldBeInvisible = !lastPageReached || this.finalButtonDisabled;
        boolean buttonIsCurrentlyInvisible = this.finalButton.getVisibility() == 4;
        boolean bl = shouldUpdateButton = buttonShouldBeInvisible != buttonIsCurrentlyInvisible;
        if (shouldUpdateButton) {
            Animator buttonAnimator;
            Animator animator = buttonAnimator = buttonShouldBeInvisible ? this.buttonAnimatorFactory.newFinalButtonDisappearAnimator((View)this.finalButton) : this.buttonAnimatorFactory.newFinalButtonAppearAnimator((View)this.finalButton);
            if (buttonShouldBeInvisible) {
                this.disableButton(buttonAnimator, this.finalButton);
            } else {
                this.enableButton(buttonAnimator, this.finalButton);
            }
        }
    }

    private void disableButton(Animator buttonAnimator, final IntroButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button cannot be null");
        }
        if (this.buttonAnimations.containsKey((Object)button)) {
            this.buttonAnimations.get((Object)button).cancel();
            this.buttonAnimations.remove((Object)button);
        }
        if (buttonAnimator != null) {
            this.buttonAnimations.put(button, buttonAnimator);
            buttonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    button.setVisibility(0);
                    button.setEnabled(false);
                }

                public void onAnimationEnd(Animator animation) {
                    button.setVisibility(4);
                }

                public void onAnimationCancel(Animator animation) {
                    button.setVisibility(0);
                    button.setEnabled(true);
                }
            });
            buttonAnimator.setDuration(150L);
            buttonAnimator.start();
        } else {
            button.setVisibility(4);
            button.setEnabled(false);
        }
    }

    private void enableButton(Animator buttonAnimator, final IntroButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button cannot be null");
        }
        if (this.buttonAnimations.containsKey((Object)button)) {
            this.buttonAnimations.get((Object)button).cancel();
            this.buttonAnimations.remove((Object)button);
        }
        if (buttonAnimator != null) {
            this.buttonAnimations.put(button, buttonAnimator);
            buttonAnimator.setStartDelay(150L);
            buttonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    button.setVisibility(0);
                    button.setEnabled(true);
                }

                public void onAnimationCancel(Animator animation) {
                    button.setVisibility(4);
                    button.setEnabled(false);
                }
            });
            buttonAnimator.setDuration(150L);
            buttonAnimator.start();
        } else {
            button.setVisibility(0);
            button.setEnabled(true);
        }
    }

    private void regenerateProgressIndicator() {
        this.progressIndicatorWrapper.removeAllViews();
        if (this.progressIndicator != null) {
            this.progressIndicatorWrapper.addView((View)this.progressIndicator);
            this.progressIndicator.setNumberOfItems(this.pages.size());
            this.progressIndicator.setSelectedItem(this.getIndexOfCurrentPage(), false);
        }
    }

    protected abstract Collection<Fragment> generatePages(Bundle var1);

    protected abstract IntroButton.Behaviour generateFinalButtonBehaviour();

    public final void hideStatusBar() {
        StatusBarHelper.hideStatusBar((Window)this.getWindow());
    }

    public final void showStatusBar() {
        int statusBarColor = ColorHelper.getPrimaryDarkColor((Context)this, (int)-16777216);
        StatusBarHelper.showStatusBar((Window)this.getWindow(), (int)statusBarColor);
    }

    public final RelativeLayout getRootView() {
        return this.rootView;
    }

    public final void changeHorizontalDividerVisibility(boolean show) {
        this.horizontalDivider.setVisibility(show ? 0 : 4);
    }

    public final void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public final void addPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.addOnPageChangeListener(listener);
    }

    public final void removePageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.removeOnPageChangeListener(listener);
    }

    public final Collection<Fragment> getPages() {
        return Collections.unmodifiableCollection(this.pages);
    }

    public final Fragment getPage(int pageIndex) {
        return (Fragment)this.pages.get(pageIndex);
    }

    public final Fragment getCurrentPage() {
        return (Fragment)this.pages.get(this.viewPager.getCurrentItem());
    }

    public final Fragment getFirstPage() {
        return (Fragment)this.pages.get(0);
    }

    public final Fragment getLastPage() {
        return (Fragment)this.pages.get(this.pages.size() - 1);
    }

    public final int getIndexOfPage(Fragment page) {
        return this.pages.indexOf((Object)page);
    }

    public final int getIndexOfCurrentPage() {
        return this.viewPager.getCurrentItem();
    }

    public final void goToPage(int pageIndex) {
        this.viewPager.setCurrentItem(pageIndex);
    }

    public final void goToLastPage() {
        this.viewPager.setCurrentItem(this.pages.size() - 1);
    }

    public final void goToFirstPage() {
        this.viewPager.setCurrentItem(0);
    }

    public final void goToNextPage() {
        boolean isLastPage;
        boolean bl = isLastPage = this.viewPager.getCurrentItem() == this.pages.size() - 1;
        if (!isLastPage) {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() + 1, true);
        }
    }

    public final void goToPreviousPage() {
        boolean isFirstPage;
        boolean bl = isFirstPage = this.viewPager.getCurrentItem() == 0;
        if (!isFirstPage) {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() - 1, true);
        }
    }

    public final int numberOfPages() {
        return this.pages.size();
    }

    public final void setPagingLockMode(LockableViewPager.LockMode lockMode) {
        this.viewPager.setLockMode(lockMode);
    }

    public final LockableViewPager.LockMode getPagingLockMode() {
        return this.viewPager.getLockMode();
    }

    public final void setBackgroundManager(BackgroundManager backgroundManager) {
        this.backgroundManager = backgroundManager;
    }

    public final BackgroundManager getBackgroundManager() {
        return this.backgroundManager;
    }

    public void setProgressIndicator(SelectionIndicator selectionIndicator) {
        if (!(selectionIndicator instanceof View)) {
            throw new IllegalArgumentException("selectionIndicator must be a subclass of android.view.View");
        }
        this.progressIndicator = selectionIndicator;
        this.regenerateProgressIndicator();
    }

    public SelectionIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void enableProgressIndicatorAnimations(boolean enableAnimations) {
        this.progressIndicatorAnimationsEnabled = enableAnimations;
    }

    public boolean progressIndicatorAnimationsAreEnabled() {
        return this.progressIndicatorAnimationsEnabled;
    }

    protected AnimatorFactory generateButtonAnimatorFactory() {
        return new FadeAnimatorFactory();
    }

    public IntroButtonAccessor getLeftButtonAccessor() {
        return new IntroButtonAccessor(this.leftButton);
    }

    public IntroButtonAccessor getRightButtonAccessor() {
        return new IntroButtonAccessor(this.rightButton);
    }

    public IntroButtonAccessor getFinalButtonAccessor() {
        return new IntroButtonAccessor(this.finalButton);
    }

    public final void disableLeftButton(boolean disabled) {
        this.leftButtonDisabled = disabled;
        this.reflectMemberVariablesInLeftButton();
    }

    public final void disableLeftButtonOnLastPage(boolean disableButton) {
        this.disableLeftButtonOnLastPage = disableButton;
        this.reflectMemberVariablesInLeftButton();
    }

    public final boolean leftButtonIsEntirelyDisabled() {
        return this.leftButtonDisabled;
    }

    public final boolean leftButtonIsDisabledOnLastPage() {
        return this.disableLeftButtonOnLastPage;
    }

    public final void disableRightButton(boolean disabled) {
        this.rightButtonDisabled = disabled;
        this.reflectMemberVariablesInRightButton();
    }

    public final boolean rightButtonIsDisabled() {
        return this.rightButtonDisabled;
    }

    public final void disableFinalButton(boolean disabled) {
        this.finalButtonDisabled = disabled;
        this.reflectMemberVariablesInFinalButton();
    }

    public final boolean finalButtonIsDisabled() {
        return this.finalButtonDisabled;
    }
}

