/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.buttons;

import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.matthewtamlin.sliding_intro_screen_library.buttons.IntroButton;

public final class IntroButtonAccessor {
    private final IntroButton button;

    public IntroButtonAccessor(IntroButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button cannot be null");
        }
        this.button = button;
    }

    public final void setBehaviour(IntroButton.Behaviour behaviour) {
        this.button.setBehaviour(behaviour);
    }

    public final IntroButton.Behaviour getBehaviour() {
        return this.button.getBehaviour();
    }

    public final void setAppearance(IntroButton.Appearance appearance) {
        this.button.setAppearance(appearance);
    }

    public final IntroButton.Appearance getAppearance() {
        return this.button.getAppearance();
    }

    public final void setText(CharSequence text, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.button.setLabel(text, behaviourClass);
    }

    public final CharSequence getText(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.button.getLabel(behaviourClass);
    }

    public final void setIcon(Drawable icon, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.button.setIcon(icon, behaviourClass);
    }

    public final Drawable getIcon(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.button.getIcon(behaviourClass);
    }

    public final void setTextColor(int color) {
        this.button.setTextColor(color);
    }

    public final int getTextColor() {
        return this.button.getCurrentTextColor();
    }

    public final void setTypeface(Typeface tf) {
        this.button.setTypeface(tf);
    }

    public final void setTextSize(float textSizeSp) {
        this.button.setTextSize(textSizeSp);
    }

    public final float getTextSize() {
        return this.button.getTextSize();
    }

    public final void setOnClickListener(View.OnClickListener l) {
        this.button.setOnClickListener(l);
    }
}

