/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.buttons;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.matthewtamlin.sliding_intro_screen_library.R;
import com.matthewtamlin.sliding_intro_screen_library.buttons.AppearanceManipulator;
import com.matthewtamlin.sliding_intro_screen_library.core.IntroActivity;
import java.util.HashMap;

public class IntroButton
extends Button {
    private static final String TAG = "[IntroButton]";
    private final Behaviour DEFAULT_BEHAVIOUR;
    private static final Appearance DEFAULT_APPEARANCE = Appearance.TEXT_ONLY;
    private Behaviour behaviour;
    private Appearance appearance;
    private final HashMap<Class<? extends Behaviour>, CharSequence> labels;
    private final HashMap<Class<? extends Behaviour>, Drawable> icons;
    private IntroActivity activity;
    private View.OnClickListener externalOnClickListener;
    private final View.OnClickListener internalOnClickListenerDelegate;

    public IntroButton(Context context) {
        super(context);
        this.behaviour = this.DEFAULT_BEHAVIOUR = new GoToPreviousPage();
        this.appearance = DEFAULT_APPEARANCE;
        this.labels = new HashMap();
        this.icons = new HashMap();
        this.internalOnClickListenerDelegate = new View.OnClickListener(){

            public void onClick(View v) {
                if (IntroButton.this.behaviour != null) {
                    IntroButton.this.behaviour.setActivity(IntroButton.this.activity);
                    IntroButton.this.behaviour.run();
                }
                if (IntroButton.this.externalOnClickListener != null) {
                    IntroButton.this.externalOnClickListener.onClick(v);
                }
            }
        };
        this.init();
    }

    public IntroButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.behaviour = this.DEFAULT_BEHAVIOUR = new GoToPreviousPage();
        this.appearance = DEFAULT_APPEARANCE;
        this.labels = new HashMap();
        this.icons = new HashMap();
        this.internalOnClickListenerDelegate = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public IntroButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.behaviour = this.DEFAULT_BEHAVIOUR = new GoToPreviousPage();
        this.appearance = DEFAULT_APPEARANCE;
        this.labels = new HashMap();
        this.icons = new HashMap();
        this.internalOnClickListenerDelegate = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private void init() {
        super.setOnClickListener(this.internalOnClickListenerDelegate);
        this.initialiseLabelsToDefault();
        this.initialiseIconsToDefault();
        if (this.getContext() instanceof IntroActivity) {
            this.activity = (IntroActivity)this.getContext();
        }
        this.updateUI();
    }

    private void initialiseLabelsToDefault() {
        this.labels.put(GoToPreviousPage.class, this.getContext().getString(R.string.introActivity_defaultBackButtonText));
        this.labels.put(GoToNextPage.class, this.getContext().getString(R.string.introActivity_defaultNextButtonText));
        this.labels.put(GoToFirstPage.class, this.getContext().getString(R.string.introActivity_defaultFirstButtonText));
        this.labels.put(GoToLastPage.class, this.getContext().getString(R.string.introActivity_defaultLastButtonText));
        this.labels.put(ProgressToNextActivity.class, this.getContext().getString(R.string.introActivity_defaultFinalButtonText));
    }

    private void initialiseIconsToDefault() {
        this.icons.put(GoToPreviousPage.class, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.introbutton_behaviour_previous));
        this.icons.put(GoToNextPage.class, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.introbutton_behaviour_next));
        this.icons.put(GoToFirstPage.class, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.introbutton_behaviour_first));
        this.icons.put(GoToLastPage.class, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.introbutton_behaviour_last));
        this.icons.put(ProgressToNextActivity.class, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.introbutton_behaviour_last));
    }

    private void updateUI() {
        AppearanceManipulator manipulator;
        AppearanceManipulator appearanceManipulator = manipulator = this.appearance == null ? null : this.appearance.getManipulator();
        if (manipulator != null) {
            manipulator.setButton(this);
            manipulator.manipulateAppearance();
        }
    }

    public void setBehaviour(Behaviour behaviour) {
        if (behaviour == null) {
            throw new IllegalArgumentException("behaviour cannot be null");
        }
        this.behaviour = behaviour;
        this.updateUI();
    }

    public Behaviour getBehaviour() {
        return this.behaviour;
    }

    public void setAppearance(Appearance appearance) {
        if (appearance == null) {
            throw new IllegalArgumentException("appearance cannot be null");
        }
        this.appearance = appearance;
        this.updateUI();
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setLabel(CharSequence label, Class<? extends Behaviour> behaviourClass) {
        Class<? extends Behaviour> behaviourClassToSet = behaviourClass == null ? this.behaviour.getClass() : behaviourClass;
        this.labels.put(behaviourClassToSet, label);
        this.updateUI();
    }

    public CharSequence getLabel(Class<? extends Behaviour> behaviourClass) {
        Class<? extends Behaviour> behaviourClassToGet = behaviourClass == null ? this.behaviour.getClass() : behaviourClass;
        return this.labels.get(behaviourClassToGet);
    }

    public void setIcon(Drawable icon, Class<? extends Behaviour> behaviourClass) {
        Class<? extends Behaviour> behaviourClassToSet = behaviourClass == null ? this.behaviour.getClass() : behaviourClass;
        this.icons.put(behaviourClassToSet, icon);
        this.updateUI();
    }

    public Drawable getIcon(Class<? extends Behaviour> behaviourClass) {
        Class<? extends Behaviour> behaviourClassToSet = behaviourClass == null ? this.behaviour.getClass() : behaviourClass;
        return this.icons.get(behaviourClassToSet);
    }

    public void setActivity(IntroActivity activity) {
        this.activity = activity;
    }

    public IntroActivity getActivity() {
        return this.activity;
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.updateUI();
    }

    public void setTypeface(Typeface tf, int style) {
        super.setTypeface(tf, style);
        this.updateUI();
    }

    public void setTypeface(Typeface tf) {
        super.setTypeface(tf);
        this.updateUI();
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.externalOnClickListener = l;
    }

    @TargetApi(value=23)
    public static final class RequestPermissions
    extends BehaviourAdapter {
        private final String[] permissions;
        private final int requestCode;

        public RequestPermissions(String[] permissions, int requestCode) {
            this.permissions = permissions;
            this.requestCode = requestCode;
        }

        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().requestPermissions(this.permissions, this.requestCode);
            }
        }
    }

    @TargetApi(value=16)
    public static final class CloseApp
    extends BehaviourAdapter {
        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().finishAffinity();
            }
        }
    }

    public static final class DoNothing
    extends BehaviourAdapter {
        @Override
        public final void run() {
        }
    }

    public static class ProgressToNextActivity
    extends BehaviourAdapter {
        private final Intent startNextActivity;
        private final SharedPreferences.Editor editsToMake;

        public ProgressToNextActivity(Intent startNextActivity, SharedPreferences.Editor editsToMake) {
            if (startNextActivity == null) {
                throw new IllegalArgumentException("startNextActivity cannot be null");
            }
            this.startNextActivity = startNextActivity;
            this.editsToMake = editsToMake;
        }

        public boolean shouldLaunchActivity() {
            return true;
        }

        @Override
        public final void run() {
            if (this.getActivity() != null && this.shouldLaunchActivity()) {
                if (this.editsToMake != null) {
                    this.editsToMake.apply();
                }
                this.getActivity().startActivity(this.startNextActivity);
            }
        }
    }

    public static final class GoToLastPage
    extends BehaviourAdapter {
        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().goToLastPage();
            }
        }
    }

    public static final class GoToFirstPage
    extends BehaviourAdapter {
        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().goToFirstPage();
            }
        }
    }

    public static final class GoToNextPage
    extends BehaviourAdapter {
        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().goToNextPage();
            }
        }
    }

    public static final class GoToPreviousPage
    extends BehaviourAdapter {
        @Override
        public final void run() {
            if (this.getActivity() != null) {
                this.getActivity().goToPreviousPage();
            }
        }
    }

    public static abstract class BehaviourAdapter
    implements Behaviour {
        private IntroActivity activity;

        @Override
        public void setActivity(IntroActivity activity) {
            this.activity = activity;
        }

        @Override
        public IntroActivity getActivity() {
            return this.activity;
        }
    }

    public static interface Behaviour
    extends Runnable {
        public void setActivity(IntroActivity var1);

        public IntroActivity getActivity();

        @Override
        public void run();
    }

    public static enum Appearance {
        TEXT_ONLY(new AppearanceManipulator(){

            @Override
            public void manipulateAppearance() {
                IntroButton button = this.getButton();
                CharSequence text = button.getLabel(null);
                button.setText(text);
                button.setCompoundDrawables(null, null, null, null);
            }
        }),
        ICON_ONLY(new AppearanceManipulator(){

            @Override
            public void manipulateAppearance() {
                IntroButton button = this.getButton();
                Drawable icon = button.getIcon(null);
                button.setText(null);
                button.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
            }
        }),
        TEXT_WITH_LEFT_ICON(new AppearanceManipulator(){

            @Override
            public void manipulateAppearance() {
                IntroButton button = this.getButton();
                Drawable icon = button.getIcon(null);
                button.setText(button.getLabel(null));
                button.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
            }
        }),
        TEXT_WITH_RIGHT_ICON(new AppearanceManipulator(){

            @Override
            public void manipulateAppearance() {
                IntroButton button = this.getButton();
                CharSequence text = button.getLabel(null);
                Drawable icon = button.getIcon(null);
                button.setText(text);
                button.setCompoundDrawablesWithIntrinsicBounds(null, null, icon, null);
            }
        });

        private final AppearanceManipulator manipulator;

        private Appearance(AppearanceManipulator manipulator) {
            this.manipulator = manipulator;
        }

        public AppearanceManipulator getManipulator() {
            return this.manipulator;
        }
    }
}

