/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.buttons;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import com.matthewtamlin.sliding_intro_screen_library.buttons.AnimatorFactory;

public class FadeAnimatorFactory
implements AnimatorFactory {
    @Override
    public Animator newLeftButtonAppearAnimator(View leftButton) {
        return this.createFade(leftButton, 0.0f, 1.0f);
    }

    @Override
    public Animator newLeftButtonDisappearAnimator(View leftButton) {
        return this.createFade(leftButton, 1.0f, 0.0f);
    }

    @Override
    public Animator newRightButtonAppearAnimator(View rightButton) {
        return this.createFade(rightButton, 0.0f, 1.0f);
    }

    @Override
    public Animator newRightButtonDisappearAnimator(View rightButton) {
        return this.createFade(rightButton, 1.0f, 0.0f);
    }

    @Override
    public Animator newFinalButtonAppearAnimator(View finalButton) {
        return this.createFade(finalButton, 0.0f, 1.0f);
    }

    @Override
    public Animator newFinalButtonDisappearAnimator(View finalButton) {
        return this.createFade(finalButton, 1.0f, 0.0f);
    }

    private Animator createFade(final View button, float startAlpha, float endAlpha) {
        ValueAnimator fadeAnimator = ValueAnimator.ofFloat((float[])new float[]{startAlpha, endAlpha});
        fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                button.setAlpha(value);
            }
        });
        return fadeAnimator;
    }
}

