/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library.background;

import android.view.View;
import com.matthewtamlin.android_utilities_library.helpers.ColorHelper;
import com.matthewtamlin.sliding_intro_screen_library.background.BackgroundManager;

public class ColorBlender
implements BackgroundManager {
    private final int[] colors;

    public ColorBlender(int[] colors) {
        if (colors == null) {
            throw new IllegalArgumentException("colors cannot be null");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("colors must have at least one element");
        }
        this.colors = colors;
    }

    @Override
    public void updateBackground(View background, int index, float offset) {
        if (index > this.colors.length - 1) {
            throw new IllegalArgumentException("index is too large");
        }
        int colorLeft = this.colors[index];
        boolean isLast = index == this.colors.length - 1;
        int colorRight = isLast ? this.colors[index] : this.colors[index + 1];
        background.setBackgroundColor(ColorHelper.blendColors((int)colorLeft, (int)colorRight, (float)(1.0f - offset)));
    }
}

