/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.matthewtamlin.sliding_intro_screen_library.Page;
import com.matthewtamlin.sliding_intro_screen_library.R;

public class ParallaxPage
extends Page {
    private static final String TAG = "[ParallaxPage]";
    protected FrameLayout rootView;
    protected ImageView frontImageHolder;
    protected ImageView backImageHolder;
    protected TextView textHolder;
    protected Bitmap frontImage = null;
    protected Bitmap backImage = null;
    protected CharSequence text = null;

    public static ParallaxPage newInstance() {
        return new ParallaxPage();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = (FrameLayout)inflater.inflate(R.layout.fragment_parallax_page, container, false);
        this.frontImageHolder = (ImageView)this.rootView.findViewById(R.id.page_fragment_imageHolderFront);
        this.backImageHolder = (ImageView)this.rootView.findViewById(R.id.page_fragment_imageHolderBack);
        this.textHolder = (TextView)this.rootView.findViewById(R.id.page_fragment_textHolder);
        this.notifyFrontImageChanged();
        this.notifyBackImageChanged();
        this.notifyTextChanged();
        return this.rootView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void setFrontImage(Bitmap frontImage) {
        this.frontImage = frontImage;
        this.notifyFrontImageChanged();
    }

    public Bitmap getFrontImage() {
        return this.frontImage;
    }

    public int getFrontImageHolderResId() {
        return this.frontImageHolder.getId();
    }

    public void setBackImage(Bitmap backImage) {
        this.backImage = backImage;
        this.notifyBackImageChanged();
    }

    public Bitmap getBackImage() {
        return this.backImage;
    }

    public int getBackImageHolderResId() {
        return this.backImageHolder.getId();
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.notifyTextChanged();
    }

    public CharSequence getText() {
        return this.text;
    }

    public int getTextHolderResId() {
        return this.textHolder.getId();
    }

    public void notifyFrontImageChanged() {
        if (this.frontImageHolder != null) {
            this.frontImageHolder.setImageBitmap(null);
            this.frontImageHolder.setImageBitmap(this.frontImage);
        }
    }

    public void notifyBackImageChanged() {
        if (this.backImageHolder != null) {
            this.backImageHolder.setImageBitmap(null);
            this.backImageHolder.setImageBitmap(this.backImage);
        }
    }

    public void notifyTextChanged() {
        if (this.textHolder != null) {
            this.textHolder.setText(null);
            this.textHolder.setText(this.text);
        }
    }
}

