/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.matthewtamlin.android_utilities_library.collections.ArrayListWithCallbacks;
import com.matthewtamlin.android_utilities_library.helpers.ColorHelper;
import com.matthewtamlin.android_utilities_library.helpers.StatusBarHelper;
import com.matthewtamlin.sliding_intro_screen_library.DotIndicator;
import com.matthewtamlin.sliding_intro_screen_library.IntroButton;
import com.matthewtamlin.sliding_intro_screen_library.LockableViewPager;
import com.matthewtamlin.sliding_intro_screen_library.Page;
import com.matthewtamlin.sliding_intro_screen_library.PageAdapter;
import com.matthewtamlin.sliding_intro_screen_library.R;
import com.matthewtamlin.sliding_intro_screen_library.SelectionIndicator;
import java.util.Collection;
import java.util.Collections;

public abstract class IntroActivity
extends AppCompatActivity
implements ViewPager.OnPageChangeListener,
ArrayListWithCallbacks.OnListChangedListener {
    private static final String TAG = "[IntroActivity]";
    private static final String STATE_KEY_CURRENT_PAGE_INDEX = "current page index";
    private static final int DEFAULT_CURRENT_PAGE_INDEX = 0;
    private final IntroButton.Behaviour DEFAULT_LEFT_BUTTON_BEHAVIOUR = new IntroButton.GoToLastPage();
    private final IntroButton.Behaviour DEFAULT_RIGHT_BUTTON_BEHAVIOUR = new IntroButton.GoToNextPage();
    private static final IntroButton.Appearance DEFAULT_LEFT_BUTTON_APPEARANCE = IntroButton.Appearance.TEXT_ONLY;
    private static final IntroButton.Appearance DEFAULT_RIGHT_BUTTON_APPEARANCE = IntroButton.Appearance.ICON_ONLY;
    private static final IntroButton.Appearance DEFAULT_FINAL_BUTTON_APPEARANCE = IntroButton.Appearance.TEXT_ONLY;
    private static final CharSequence DEFAULT_FINAL_BUTTON_TEXT = "DONE";
    private RelativeLayout rootView;
    private LockableViewPager viewPager;
    private FrameLayout progressIndicatorHelper;
    private IntroButton leftButton;
    private IntroButton rightButton;
    private IntroButton finalButton;
    private SelectionIndicator progressIndicator;
    private final ArrayListWithCallbacks<Page> pages = new ArrayListWithCallbacks();
    private final PageAdapter adapter = new PageAdapter(this.getSupportFragmentManager(), this.pages);
    private boolean progressIndicatorAnimationsEnabled = true;
    private boolean leftButtonDisabled = false;
    private boolean rightButtonDisabled = false;
    private boolean finalButtonDisabled = false;
    private boolean hideLeftButtonOnLastPage = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_intro);
        this.bindViews();
        this.registerListeners();
        for (Page p : this.generatePages(savedInstanceState)) {
            this.pages.add((Object)p);
        }
        this.initialiseNavigationButtons();
        this.initialiseViewPager(savedInstanceState);
        this.updateButtonVisibilities();
        this.progressIndicator = new DotIndicator((Context)this);
        this.regenerateProgressIndicator();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_KEY_CURRENT_PAGE_INDEX, this.viewPager.getCurrentItem());
    }

    public void onBackPressed() {
        if (this.viewPager.getCurrentItem() == 0 || !this.getPagingLockMode().allowsCommands()) {
            super.onBackPressed();
        } else {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() - 1);
        }
    }

    private void bindViews() {
        this.rootView = (RelativeLayout)this.findViewById(R.id.intro_activity_root);
        this.viewPager = (LockableViewPager)this.findViewById(R.id.intro_activity_viewPager);
        this.progressIndicatorHelper = (FrameLayout)this.findViewById(R.id.intro_activity_progressIndicatorHolder);
        this.leftButton = (IntroButton)this.findViewById(R.id.intro_activity_leftButton);
        this.rightButton = (IntroButton)this.findViewById(R.id.intro_activity_rightButton);
        this.finalButton = (IntroButton)this.findViewById(R.id.intro_activity_finalButton);
    }

    private void registerListeners() {
        this.viewPager.addOnPageChangeListener(this);
        this.pages.addOnListChangedListener((ArrayListWithCallbacks.OnListChangedListener)this);
    }

    private void initialiseViewPager(Bundle savedInstanceState) {
        int index = savedInstanceState == null ? 0 : savedInstanceState.getInt(STATE_KEY_CURRENT_PAGE_INDEX, 0);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.setCurrentItem(index);
        this.updateBackground(0, 1.0f);
    }

    private void initialiseNavigationButtons() {
        this.leftButton.setBehaviour(this.DEFAULT_LEFT_BUTTON_BEHAVIOUR);
        this.leftButton.setAppearance(DEFAULT_LEFT_BUTTON_APPEARANCE);
        this.leftButton.setActivity(this);
        this.rightButton.setBehaviour(this.DEFAULT_RIGHT_BUTTON_BEHAVIOUR);
        this.rightButton.setAppearance(DEFAULT_RIGHT_BUTTON_APPEARANCE);
        this.rightButton.setActivity(this);
        this.finalButton.setBehaviour(this.generateFinalButtonBehaviour());
        this.finalButton.setAppearance(DEFAULT_FINAL_BUTTON_APPEARANCE);
        this.finalButton.setText(DEFAULT_FINAL_BUTTON_TEXT, null);
        this.finalButton.setActivity(this);
    }

    private void updateButtonVisibilities() {
        boolean disableFinalButton;
        boolean reachedLastPage = this.viewPager.getCurrentItem() + 1 == this.pages.size();
        boolean disableLeftButton = this.hideLeftButtonOnLastPage && reachedLastPage || this.leftButtonDisabled;
        boolean disableRightButton = reachedLastPage || this.rightButtonDisabled;
        boolean bl = disableFinalButton = !reachedLastPage || this.finalButtonDisabled;
        if (disableLeftButton) {
            this.leftButton.setVisibility(4);
            this.leftButton.setEnabled(false);
        } else {
            this.leftButton.setVisibility(0);
            this.leftButton.setEnabled(true);
        }
        if (disableRightButton) {
            this.rightButton.setVisibility(4);
            this.rightButton.setEnabled(false);
        } else {
            this.rightButton.setVisibility(0);
            this.rightButton.setEnabled(true);
        }
        if (disableFinalButton) {
            this.finalButton.setVisibility(4);
            this.finalButton.setEnabled(false);
        } else {
            this.finalButton.setVisibility(0);
            this.finalButton.setEnabled(true);
        }
    }

    private void regenerateProgressIndicator() {
        this.progressIndicatorHelper.removeAllViews();
        if (this.progressIndicator != null) {
            this.progressIndicatorHelper.addView((View)this.progressIndicator);
            this.progressIndicator.setNumberOfItems(this.pages.size());
            if (this.pages.size() > 0) {
                this.progressIndicator.setSelectedItem(this.getIndexOfCurrentPage(), false);
            }
        }
    }

    private void updateBackground(int leftIndex, float offset) {
        if (this.pages.size() > 0) {
            int color1 = ((Page)((Object)this.pages.get(leftIndex))).getDesiredBackgroundColor();
            boolean isFinalPage = leftIndex == this.pages.size() - 1;
            int color2 = isFinalPage ? ((Page)((Object)this.pages.get(leftIndex))).getDesiredBackgroundColor() : ((Page)((Object)this.pages.get(leftIndex + 1))).getDesiredBackgroundColor();
            this.rootView.setBackgroundColor(ColorHelper.blendColors((int)color1, (int)color2, (float)(1.0f - offset)));
        } else {
            this.rootView.setBackgroundColor(-7829368);
        }
    }

    protected abstract Collection<Page> generatePages(Bundle var1);

    protected abstract IntroButton.Behaviour generateFinalButtonBehaviour();

    public final void hideStatusBar() {
        StatusBarHelper.hideStatusBar((Window)this.getWindow());
    }

    public final void showStatusBar() {
        int statusBarColor = ColorHelper.getPrimaryDarkColor((Context)this, (int)-16777216);
        StatusBarHelper.showStatusBar((Window)this.getWindow(), (int)statusBarColor);
    }

    public final RelativeLayout getRootView() {
        return this.rootView;
    }

    public final void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public final Collection<Page> getPages() {
        return Collections.unmodifiableCollection(this.pages);
    }

    public final Page getPage(int pageIndex) {
        return (Page)((Object)this.pages.get(pageIndex));
    }

    public final Page getCurrentPage() {
        return (Page)((Object)this.pages.get(this.viewPager.getCurrentItem()));
    }

    public final Page getFirstPage() {
        return (Page)((Object)this.pages.get(0));
    }

    public final Page getLastPage() {
        return (Page)((Object)this.pages.get(this.pages.size() - 1));
    }

    public final int getIndexOfPage(Page page) {
        return this.pages.indexOf((Object)page);
    }

    public final int getIndexOfCurrentPage() {
        return this.viewPager.getCurrentItem();
    }

    public final void goToPage(int pageIndex) {
        this.viewPager.setCurrentItem(pageIndex);
    }

    public final void goToLastPage() {
        this.viewPager.setCurrentItem(this.pages.size() - 1);
    }

    public final void goToFirstPage() {
        this.viewPager.setCurrentItem(0);
    }

    public final void goToNextPage() {
        boolean isLastPage;
        boolean bl = isLastPage = this.viewPager.getCurrentItem() == this.pages.size() - 1;
        if (!isLastPage) {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() + 1, true);
        }
    }

    public final void goToPreviousPage() {
        boolean isFirstPage;
        boolean bl = isFirstPage = this.viewPager.getCurrentItem() == 0;
        if (!isFirstPage) {
            this.viewPager.setCurrentItem(this.viewPager.getCurrentItem() - 1, true);
        }
    }

    public final int numberOfPages() {
        return this.pages.size();
    }

    public final void setPagingLockMode(LockableViewPager.LockMode lockMode) {
        this.viewPager.setLockMode(lockMode);
    }

    public final LockableViewPager.LockMode getPagingLockMode() {
        return this.viewPager.getLockMode();
    }

    public void setProgressIndicator(SelectionIndicator selectionIndicator) {
        if (!(selectionIndicator instanceof View)) {
            throw new IllegalArgumentException("selectionIndicator must be a subclass of android.view.View");
        }
        this.progressIndicator = selectionIndicator;
        this.regenerateProgressIndicator();
    }

    public SelectionIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void enableProgressIndicatorAnimations(boolean enableAnimations) {
        this.progressIndicatorAnimationsEnabled = enableAnimations;
    }

    public boolean progressIndicatorAnimationsAreEnabled() {
        return this.progressIndicatorAnimationsEnabled;
    }

    public final void setLeftButtonBehaviour(IntroButton.Behaviour behaviour) {
        this.leftButton.setBehaviour(behaviour);
    }

    public final IntroButton.Behaviour getLeftButtonBehaviour() {
        return this.leftButton.getBehaviour();
    }

    public final void setLeftButtonAppearance(IntroButton.Appearance appearance) {
        this.leftButton.setAppearance(appearance);
    }

    public final IntroButton.Appearance getLeftButtonAppearance() {
        return this.leftButton.getAppearance();
    }

    public final void setLeftButtonText(CharSequence text, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.leftButton.setLabel(text, behaviourClass);
    }

    public final CharSequence getLeftButtonText(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.leftButton.getLabel(behaviourClass);
    }

    public final void setLeftButtonIcon(Drawable icon, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.leftButton.setIcon(icon, behaviourClass);
    }

    public final Drawable getLeftButtonIcon(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.leftButton.getIcon(behaviourClass);
    }

    public final void setLeftButtonTextColor(int color) {
        this.leftButton.setTextColor(color);
    }

    public final int getLeftButtonTextColor() {
        return this.leftButton.getCurrentTextColor();
    }

    public final void setLeftButtonTextSize(float sizeSp) {
        this.leftButton.setTextSize(sizeSp);
    }

    public final float getLeftButtonTextSize() {
        return this.leftButton.getTextSize();
    }

    public final void setLeftButtonTypeface(Typeface tf, int style) {
        this.leftButton.setTypeface(tf, style);
    }

    public final void setLeftButtonTypeface(Typeface tf) {
        this.leftButton.setTypeface(tf);
    }

    public final void setLeftButtonOnClickListener(View.OnClickListener l) {
        this.leftButton.setOnClickListener(l);
    }

    public final void disableLeftButton(boolean disabled) {
        this.leftButtonDisabled = disabled;
        this.updateButtonVisibilities();
    }

    public final boolean leftButtonIsDisabled() {
        return this.leftButtonDisabled;
    }

    public final void hideLeftButtonOnLastPage(boolean hideButton) {
        this.hideLeftButtonOnLastPage = hideButton;
        this.updateButtonVisibilities();
    }

    public final boolean leftButtonIsHiddenOnLastPage() {
        return this.hideLeftButtonOnLastPage;
    }

    public final void setRightButtonBehaviour(IntroButton.Behaviour behaviour) {
        this.rightButton.setBehaviour(behaviour);
    }

    public final IntroButton.Behaviour getRightButtonBehaviour() {
        return this.rightButton.getBehaviour();
    }

    public final void setRightButtonAppearance(IntroButton.Appearance appearance) {
        this.rightButton.setAppearance(appearance);
    }

    public final IntroButton.Appearance getRightButtonAppearance() {
        return this.rightButton.getAppearance();
    }

    public final void setRightButtonText(CharSequence text, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.rightButton.setLabel(text, behaviourClass);
    }

    public final CharSequence getRightButtonText(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.rightButton.getLabel(behaviourClass);
    }

    public final void setRightButtonIcon(Drawable icon, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.rightButton.setIcon(icon, behaviourClass);
    }

    public final Drawable getRightButtonIcon(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.rightButton.getIcon(behaviourClass);
    }

    public final void setRightButtonTextColor(int color) {
        this.rightButton.setTextColor(color);
    }

    public final int getRightButtonTextColor() {
        return this.rightButton.getCurrentTextColor();
    }

    public final void setRightButtonTextSize(float sizeSp) {
        this.rightButton.setTextSize(sizeSp);
    }

    public final float getRightButtonTextSize() {
        return this.rightButton.getTextSize();
    }

    public final void setRightButtonTypeface(Typeface tf, int style) {
        this.rightButton.setTypeface(tf, style);
    }

    public final void setRightButtonTypeface(Typeface tf) {
        this.rightButton.setTypeface(tf);
    }

    public final void setRightButtonOnClickListener(View.OnClickListener l) {
        this.rightButton.setOnClickListener(l);
    }

    public final void disableRightButton(boolean disabled) {
        this.rightButtonDisabled = disabled;
        this.updateButtonVisibilities();
    }

    public final boolean rightButtonIsDisabled() {
        return this.rightButtonDisabled;
    }

    public final void setFinalButtonBehaviour(IntroButton.Behaviour behaviour) {
        this.finalButton.setBehaviour(behaviour);
    }

    public final IntroButton.Behaviour getFinalButtonBehaviour() {
        return this.finalButton.getBehaviour();
    }

    public final void setFinalButtonAppearance(IntroButton.Appearance appearance) {
        this.finalButton.setAppearance(appearance);
    }

    public final IntroButton.Appearance getFinalButtonAppearance() {
        return this.finalButton.getAppearance();
    }

    public final void setFinalButtonText(CharSequence text, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.finalButton.setLabel(text, behaviourClass);
    }

    public final CharSequence getFinalButtonText(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.finalButton.getLabel(behaviourClass);
    }

    public final void setFinalButtonIcon(Drawable icon, Class<? extends IntroButton.Behaviour> behaviourClass) {
        this.finalButton.setIcon(icon, behaviourClass);
    }

    public final Drawable getFinalButtonIcon(Class<? extends IntroButton.Behaviour> behaviourClass) {
        return this.finalButton.getIcon(behaviourClass);
    }

    public final void setFinalButtonTextColor(int color) {
        this.finalButton.setTextColor(color);
    }

    public final int getFinalButtonTextColor() {
        return this.finalButton.getCurrentTextColor();
    }

    public final void setFinalButtonTextSize(float sizeSp) {
        this.finalButton.setTextSize(sizeSp);
    }

    public final float getFinalButtonTextSize() {
        return this.finalButton.getTextSize();
    }

    public final void setFinalButtonTypeface(Typeface tf, int style) {
        this.finalButton.setTypeface(tf, style);
    }

    public final void setFinalButtonTypeface(Typeface tf) {
        this.finalButton.setTypeface(tf);
    }

    public final void setFinalButtonOnClickListener(View.OnClickListener l) {
        this.finalButton.setOnClickListener(l);
    }

    public final void disableFinalButton(boolean disabled) {
        this.finalButtonDisabled = disabled;
        this.updateButtonVisibilities();
    }

    public final boolean finalButtonIsDisabled() {
        return this.finalButtonDisabled;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.updateBackground(position, positionOffset);
    }

    public void onPageSelected(int position) {
        this.updateButtonVisibilities();
        if (this.progressIndicator != null) {
            this.progressIndicator.setSelectedItem(position, this.progressIndicatorAnimationsEnabled);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onItemAdded(ArrayListWithCallbacks list, Object itemAdded, int index) {
        if (list == this.pages) {
            this.updateButtonVisibilities();
            this.regenerateProgressIndicator();
        }
    }

    public void onItemRemoved(ArrayListWithCallbacks list, Object itemRemoved, int index) {
        if (list == this.pages) {
            this.updateButtonVisibilities();
            this.regenerateProgressIndicator();
        }
    }

    public void onListCleared(ArrayListWithCallbacks list) {
        if (list == this.pages) {
            this.updateButtonVisibilities();
            this.regenerateProgressIndicator();
        }
    }
}

