/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.sliding_intro_screen_library;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.matthewtamlin.android_utilities_library.helpers.DimensionHelper;
import com.matthewtamlin.sliding_intro_screen_library.Dot;
import com.matthewtamlin.sliding_intro_screen_library.R;
import com.matthewtamlin.sliding_intro_screen_library.SelectionIndicator;
import java.util.ArrayList;

public class DotIndicator
extends RelativeLayout
implements SelectionIndicator {
    private static final String TAG = "[SelectionIndicator]";
    private static final int DEFAULT_NUMBER_OF_DOTS = 1;
    private static final int DEFAULT_SELECTED_DOT_INDEX = 0;
    private static final int DEFAULT_UNSELECTED_DOT_DIAMETER_DP = 6;
    private static final int DEFAULT_SELECTED_DOT_DIAMETER_DP = 9;
    private static final int DEFAULT_UNSELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SPACING_BETWEEN_DOTS_DP = 7;
    private static final int DEFAULT_DOT_TRANSITION_DURATION_MS = 200;
    private int numberOfDots;
    private int selectedDotIndex;
    private int unselectedDotDiameterPx;
    private int selectedDotDiameterPx;
    private int unselectedDotColor;
    private int selectedDotColor;
    private int spacingBetweenDotsPx;
    private int dotTransitionDuration;
    private final ArrayList<Dot> dots = new ArrayList();

    public DotIndicator(Context context) {
        super(context);
        this.init(null);
    }

    public DotIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DotIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.DotIndicator);
        int defaultSelectedDotDiameterPx = DimensionHelper.dpToPx((int)9, (Context)this.getContext());
        int defaultUnselectedDotDiameterPx = DimensionHelper.dpToPx((int)6, (Context)this.getContext());
        int defaultSpacingBetweenDotsPx = DimensionHelper.dpToPx((int)7, (Context)this.getContext());
        this.numberOfDots = attributes.getInt(R.styleable.DotIndicator_numberOfDots, 1);
        this.selectedDotIndex = attributes.getInt(R.styleable.DotIndicator_selectedDotIndex, 0);
        this.unselectedDotDiameterPx = attributes.getDimensionPixelSize(R.styleable.DotIndicator_unselectedDotDiameter, defaultUnselectedDotDiameterPx);
        this.selectedDotDiameterPx = attributes.getDimensionPixelSize(R.styleable.DotIndicator_selectedDotDiameter, defaultSelectedDotDiameterPx);
        this.unselectedDotColor = attributes.getColor(R.styleable.DotIndicator_unselectedDotColor, -1);
        this.selectedDotColor = attributes.getColor(R.styleable.DotIndicator_selectedDotColor, -1);
        this.spacingBetweenDotsPx = attributes.getDimensionPixelSize(R.styleable.DotIndicator_spacingBetweenDots, defaultSpacingBetweenDotsPx);
        this.dotTransitionDuration = attributes.getDimensionPixelSize(R.styleable.DotIndicator_dotTransitionDuration, 200);
        attributes.recycle();
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.setGravity(17);
        this.reflectParametersInView();
    }

    private void reflectParametersInView() {
        this.dots.clear();
        this.removeAllViews();
        for (int i = 0; i < this.numberOfDots; ++i) {
            Dot dot = new Dot(this.getContext());
            dot.setInactiveDiameterPx(this.unselectedDotDiameterPx).setActiveDiameterPx(this.selectedDotDiameterPx).setActiveColor(this.selectedDotColor).setInactiveColor(this.unselectedDotColor).setTransitionDuration(this.dotTransitionDuration);
            if (i == this.selectedDotIndex) {
                dot.setActive(false);
            } else {
                dot.setInactive(false);
            }
            int maxDiameterDimension = Math.max(this.selectedDotDiameterPx, this.unselectedDotDiameterPx);
            int startMargin = i * (this.spacingBetweenDotsPx + this.unselectedDotDiameterPx);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(maxDiameterDimension, maxDiameterDimension);
            params.setMargins(startMargin, 0, 0, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                params.setMarginStart(startMargin);
            }
            dot.setLayoutParams((ViewGroup.LayoutParams)params);
            this.dots.add(i, dot);
            this.addView((View)dot);
        }
    }

    public void redrawDots() {
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterPx(int unselectedDotDiameterPx) {
        this.unselectedDotDiameterPx = unselectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterDp(int unselectedDotDiameterDp) {
        int diameterPx = DimensionHelper.dpToPx((int)unselectedDotDiameterDp, (Context)this.getContext());
        this.setUnselectedDotDiameterPx(diameterPx);
    }

    public int getUnselectedDotDiameter() {
        return this.unselectedDotDiameterPx;
    }

    public void setSelectedDotDiameterPx(int selectedDotDiameterPx) {
        this.selectedDotDiameterPx = selectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setSelectedDotDiameterDp(int selectedDotDiameterDp) {
        int diameterPx = DimensionHelper.dpToPx((int)selectedDotDiameterDp, (Context)this.getContext());
        this.setSelectedDotDiameterPx(diameterPx);
    }

    public int getSelectedDotDiameter() {
        return this.selectedDotDiameterPx;
    }

    public void setUnselectedDotColor(int unselectedDotColor) {
        this.unselectedDotColor = unselectedDotColor;
        this.reflectParametersInView();
    }

    public int getUnselectedDotColor() {
        return this.unselectedDotColor;
    }

    public void setSelectedDotColor(int selectedDotColor) {
        this.selectedDotColor = selectedDotColor;
        this.reflectParametersInView();
    }

    public int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    public void setSpacingBetweenDotsPx(int spacingBetweenDotsPx) {
        this.spacingBetweenDotsPx = spacingBetweenDotsPx;
        this.reflectParametersInView();
    }

    public void setSpacingBetweenDotsDp(int spacingBetweenDotsDp) {
        int spacingPx = DimensionHelper.dpToPx((int)spacingBetweenDotsDp, (Context)this.getContext());
        this.setSpacingBetweenDotsPx(spacingPx);
    }

    public int getSpacingBetweenDots() {
        return this.spacingBetweenDotsPx;
    }

    @Override
    public void setSelectedItem(int index, boolean animate) {
        if (this.selectedDotIndex < 0) {
            throw new IllegalArgumentException("newActiveItemIndex must be greater than 0");
        }
        try {
            this.dots.get(this.selectedDotIndex).setInactive(animate);
            this.dots.get(index).setActive(animate);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
        this.selectedDotIndex = index;
    }

    @Override
    public int getSelectedItemIndex() {
        return this.selectedDotIndex;
    }

    @Override
    public void setNumberOfItems(int numberOfItems) {
        this.numberOfDots = numberOfItems;
        this.reflectParametersInView();
    }

    @Override
    public int getNumberOfItems() {
        return this.numberOfDots;
    }

    @Override
    public void setTransitionDuration(int transitionDurationMs) {
        this.dotTransitionDuration = transitionDurationMs;
        this.reflectParametersInView();
    }

    @Override
    public int getTransitionDuration() {
        return this.dotTransitionDuration;
    }

    @Override
    public void setVisibility(boolean show) {
        this.setVisibility(show ? 0 : 4);
    }

    @Override
    public boolean isVisible() {
        return this.getVisibility() == 0;
    }
}

