/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.matthewtamlin.java_utilities.checkers.NullChecker;

public class InternetHelper {
    public static ConnectionType getInternetConnectionType(Context context) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        NetworkInfo info = InternetHelper.getNetworkInfo(context);
        if (info == null) {
            return null;
        }
        switch (info.getType()) {
            case 0: {
                return ConnectionType.MOBILE;
            }
            case 1: {
                return ConnectionType.WIFI;
            }
            case 7: {
                return ConnectionType.BLUETOOTH;
            }
            case 8: {
                return ConnectionType.MOCK;
            }
            case 9: {
                return ConnectionType.ETHERNET;
            }
            case 4: {
                return ConnectionType.MOBILE_DUN;
            }
            case 17: {
                return ConnectionType.VPN;
            }
        }
        return ConnectionType.UNKNOWN;
    }

    private static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static enum ConnectionType {
        WIFI,
        MOBILE,
        BLUETOOTH,
        ETHERNET,
        MOCK,
        MOBILE_DUN,
        VPN,
        UNKNOWN;

    }
}

