/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.matthewtamlin.java_utilities.checkers.IntChecker;
import com.matthewtamlin.java_utilities.checkers.NullChecker;

public class DimensionHelper {
    public static float dpToPx(Context context, float dpValue) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)((int)dpValue), (int)0, (String)"dpValue must be at least 0.");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)metrics);
    }

    public static float spToPx(Context context, float spValue) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)((int)spValue), (int)0, (String)"spValue must be at least 0.");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)metrics);
    }

    public static float inToPx(Context context, float inValue) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)((int)inValue), (int)0, (String)"inValue must be at least 0.");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)4, (float)inValue, (DisplayMetrics)metrics);
    }

    public static float mmToPx(Context context, float mmValue) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)((int)mmValue), (int)0, (String)"mmValue must be at least 0.");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)5, (float)mmValue, (DisplayMetrics)metrics);
    }

    public static float ptToPx(Context context, float ptValue) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)((int)ptValue), (int)0, (String)"ptValue must be at least 0.");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)3, (float)ptValue, (DisplayMetrics)metrics);
    }
}

