/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import com.matthewtamlin.android_utilities.library.R;
import com.matthewtamlin.java_utilities.checkers.NullChecker;

public class ThemeColorHelper {
    public static int getPrimaryColor(Context context, int defaultColor) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        return ThemeColorHelper.getColor(context, defaultColor, R.attr.colorPrimary);
    }

    public static int getPrimaryDarkColor(Context context, int defaultColor) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        return ThemeColorHelper.getColor(context, defaultColor, R.attr.colorPrimaryDark);
    }

    public static int getAccentColor(Context context, int defaultColor) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        return ThemeColorHelper.getColor(context, defaultColor, R.attr.colorAccent);
    }

    private static int getColor(Context context, int defaultColor, int colorAttr) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        TypedValue v = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(v.data, new int[]{colorAttr});
        int color = a.getColor(0, defaultColor);
        a.recycle();
        return color;
    }
}

