/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.graphics.Color;
import java.util.Random;

public class ColorHelper {
    public static int blendColors(int color1, int color2, float ratio) {
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be between 0 and 1 (inclusive)");
        }
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    public static int calculateBestTextColor(int backgroundColor) {
        float[] preConversionValues = new float[]{(float)Color.red((int)backgroundColor) / 255.0f, (float)Color.green((int)backgroundColor) / 255.0f, (float)Color.blue((int)backgroundColor) / 255.0f};
        float[] postConversionValues = new float[3];
        for (int i = 0; i < 3; ++i) {
            float x = preConversionValues[i];
            postConversionValues[i] = (double)x <= 0.04045 ? (float)((double)x / 12.92) : (float)Math.pow(((double)x + 0.055) / 1.055, 2.4);
        }
        float luminance = (float)(0.2126 * (double)postConversionValues[0] + 0.7152 * (double)postConversionValues[1] + 0.0722 * (double)postConversionValues[2]);
        if ((double)luminance > 0.179) {
            return -16777216;
        }
        return -1;
    }

    public static int createRandomColor(boolean randomiseTransparency) {
        Random random = new Random();
        int a = randomiseTransparency ? random.nextInt(256) : 255;
        int r = random.nextInt(256);
        int g = random.nextInt(256);
        int b = random.nextInt(256);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }
}

