/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.matthewtamlin.java_utilities.checkers.NullChecker;

public class ScreenSizeHelper {
    public static ScreenSize getScreenSize(Context context) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null");
        Resources res = context.getResources();
        int config = res.getConfiguration().screenLayout & 0xF;
        switch (config) {
            case 4: {
                return ScreenSize.EXTRA_LARGE;
            }
            case 3: {
                return ScreenSize.LARGE;
            }
            case 2: {
                return ScreenSize.NORMAL;
            }
            case 1: {
                return ScreenSize.SMALL;
            }
        }
        return ScreenSize.UNDEFINED;
    }

    public static int getScreenWidthPx(Context context) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null");
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public static int getScreenHeightPx(Context context) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null");
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels;
    }

    public static enum ScreenSize {
        SMALL,
        NORMAL,
        LARGE,
        EXTRA_LARGE,
        UNDEFINED;

    }
}

