/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.support.v4.app.ActivityCompat;
import com.matthewtamlin.java_utilities.checkers.NullChecker;

public class PermissionsHelper {
    public static boolean checkAllPermissionsGranted(Context context, String ... permissions) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        NullChecker.checkNotNull((Object)permissions, (String)"permissions cannot be null.");
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public static int countGrantedPermissions(Context context, String ... permissions) {
        NullChecker.checkNotNull((Object)context, (String)"context cannot be null.");
        NullChecker.checkNotNull((Object)permissions, (String)"permissions cannot be null.");
        int grantedPermissions = 0;
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)permission) != 0) continue;
            ++grantedPermissions;
        }
        return grantedPermissions;
    }
}

