/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.matthewtamlin.java_utilities.checkers.IntChecker;
import com.matthewtamlin.java_utilities.checkers.NullChecker;
import java.io.File;

public class BitmapEfficiencyHelper {
    public static int calculateSamplingRate(int rawWidth, int rawHeight, int desWidth, int desHeight) {
        boolean scalingIsPossible;
        if (rawWidth < 0 || rawHeight < 0 || desWidth < 0 || desHeight < 0) {
            throw new IllegalArgumentException("All dimensions must be greater than zero.");
        }
        boolean bl = scalingIsPossible = rawWidth / 2 >= desWidth && rawHeight / 2 >= desHeight;
        if (scalingIsPossible) {
            return 2 * BitmapEfficiencyHelper.calculateSamplingRate(rawWidth / 2, rawHeight / 2, desWidth, desHeight);
        }
        return 1;
    }

    public static Bitmap decodeResource(Resources res, int resId, int desWidth, int desHeight) {
        NullChecker.checkNotNull((Object)res, (String)"res cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)desWidth, (int)0, (String)"desWidth must be at least zero.");
        IntChecker.checkGreaterThanOrEqualTo((int)desHeight, (int)0, (String)"desHeight must be at least zero.");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, int desWidth, int desHeight) {
        NullChecker.checkNotNull((Object)data, (String)"data cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)offset, (int)0, (String)"offset must be at least zero.");
        IntChecker.checkLessThan((int)offset, (int)data.length, (String)("offset must be less than " + data.length));
        IntChecker.checkGreaterThanOrEqualTo((int)length, (int)0, (String)"length must be at least zero.");
        IntChecker.checkLessThanOrEqualTo((int)length, (int)(data.length - offset), (String)("length must be at most " + (data.length - offset)));
        IntChecker.checkGreaterThanOrEqualTo((int)desWidth, (int)0, (String)"desWidth must be at least zero.");
        IntChecker.checkGreaterThanOrEqualTo((int)desHeight, (int)0, (String)"desHeight must be at least zero.");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeByteArray(byte[] data, int desWidth, int desHeight) {
        return BitmapEfficiencyHelper.decodeByteArray(data, 0, data.length, desWidth, desHeight);
    }

    public static Bitmap decodeFile(File file, int desWidth, int desHeight) {
        NullChecker.checkNotNull((Object)file, (String)"file cannot be null.");
        IntChecker.checkGreaterThanOrEqualTo((int)desWidth, (int)0, (String)"desWidth must be at least zero.");
        IntChecker.checkGreaterThanOrEqualTo((int)desHeight, (int)0, (String)"desHeight must be at least zero.");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
    }
}

