/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.res.AssetManager;
import com.matthewtamlin.java_utilities.checkers.NullChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AssetsHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAssetsToDirectory(AssetManager assetsManager, File targetDirectory, String ... assets) throws IOException {
        NullChecker.checkNotNull((Object)assetsManager, (String)"assetsManager cannot be null");
        NullChecker.checkNotNull((Object)targetDirectory, (String)"targetDirectory cannot be null");
        NullChecker.checkNotNull((Object)assets, (String)"assetFiles cannot be null");
        for (String filename : assets) {
            File targetFile = new File(targetDirectory, filename);
            InputStream fromAssets = null;
            OutputStream toTarget = null;
            try {
                fromAssets = assetsManager.open(filename);
                toTarget = new FileOutputStream(targetFile);
                AssetsHelper.copyData(fromAssets, toTarget);
            }
            finally {
                if (fromAssets != null) {
                    fromAssets.close();
                }
                if (toTarget != null) {
                    toTarget.close();
                }
            }
        }
    }

    private static void copyData(InputStream source, OutputStream target) throws IOException {
        NullChecker.checkNotNull((Object)source, (String)"source cannot be null.");
        NullChecker.checkNotNull((Object)target, (String)"target cannot be null.");
        byte[] buffer = new byte[1024];
        int numberOfBytesRead = source.read(buffer);
        while (numberOfBytesRead != -1) {
            target.write(buffer, 0, numberOfBytesRead);
            numberOfBytesRead = source.read(buffer);
        }
    }
}

