/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.matthewtamlin.android_utilities.library.R;

public class SquareImageView
extends ImageView {
    private static final String TAG = "[SquareImageView]";
    private static final DerivedDimension DEFAULT_DERIVED_DIMENSION = DerivedDimension.HEIGHT;
    private DerivedDimension derivedDimension;

    public SquareImageView(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public SquareImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public SquareImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    public SquareImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.SquareImageView, defStyleAttr, defStyleRes);
        int attrValue = attributes.getInt(R.styleable.SquareImageView_derivedDimension, DEFAULT_DERIVED_DIMENSION.ordinal());
        this.derivedDimension = DerivedDimension.values()[attrValue];
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int dimensions = this.derivedDimension == DerivedDimension.WIDTH ? this.getMeasuredHeight() : this.getMeasuredWidth();
        this.setMeasuredDimension(dimensions, dimensions);
    }

    private static enum DerivedDimension {
        WIDTH,
        HEIGHT;

    }
}

