/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class DimensionHelper {
    public static int dpToPx(Context context, int dpValue) {
        DimensionHelper.checkArguments(context, dpValue, "dpValue");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)metrics);
    }

    public static float spToPx(Context context, float spValue) {
        DimensionHelper.checkArguments(context, spValue, "spValue");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)metrics);
    }

    public static float inToPx(Context context, float inValue) {
        DimensionHelper.checkArguments(context, inValue, "inValue");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)4, (float)inValue, (DisplayMetrics)metrics);
    }

    public static float mmToPx(Context context, float mmValue) {
        DimensionHelper.checkArguments(context, mmValue, "mmValue");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)5, (float)mmValue, (DisplayMetrics)metrics);
    }

    public static float ptToPx(Context context, float ptValue) {
        DimensionHelper.checkArguments(context, ptValue, "ptValue");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)3, (float)ptValue, (DisplayMetrics)metrics);
    }

    private static void checkArguments(Context context, float dimension, String dimensionParamName) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (dimension < 0.0f) {
            String dimName = dimensionParamName == null ? "dimension" : dimensionParamName;
            throw new IllegalArgumentException(dimName + " cannot be less than zero");
        }
    }
}

