/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.res.AssetManager;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AssetsHelper {
    private static final String TAG = "[AssetsHelper]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.WRITE_EXTERNAL_STORAGE"})
    public static void copyAssetsToDirectory(AssetManager assetsManager, String[] assetFiles, File targetDirectory) throws IOException {
        if (assetsManager == null) {
            throw new IllegalArgumentException("assetsManager cannot be null");
        }
        if (assetFiles == null) {
            throw new IllegalArgumentException("assetFiles cannot be null");
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException("targetDirectory cannot be null");
        }
        for (String filename : assetFiles) {
            File fileInTargetDirectory = new File(targetDirectory, filename);
            InputStream streamFromAssets = null;
            FileOutputStream streamToTargetFile = null;
            try {
                streamToTargetFile = new FileOutputStream(fileInTargetDirectory);
                streamFromAssets = assetsManager.open(filename);
                AssetsHelper.copyFile(streamFromAssets, streamToTargetFile);
            }
            catch (Throwable throwable) {
                AssetsHelper.closeStream(streamFromAssets);
                AssetsHelper.closeStream(streamToTargetFile);
                throw throwable;
            }
            AssetsHelper.closeStream(streamFromAssets);
            AssetsHelper.closeStream(streamToTargetFile);
        }
    }

    private static void copyFile(InputStream source, OutputStream target) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        byte[] buffer = new byte[1024];
        int numberOfBytesRead = source.read(buffer);
        while (numberOfBytesRead != -1) {
            target.write(buffer, 0, numberOfBytesRead);
            numberOfBytesRead = source.read(buffer);
        }
    }

    private static void closeStream(Closeable stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("[Error closing stream: " + stream + "]"), (Throwable)e);
        }
    }
}

