/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.utilities;

import android.os.Handler;
import android.os.Looper;
import com.matthewtamlin.android_utilities.library.checkers.NullChecker;
import com.matthewtamlin.android_utilities.library.utilities.UiThreadUtil;

public class LooperUiThreadUtil
implements UiThreadUtil {
    private final Looper looper;

    public static LooperUiThreadUtil createUsingLooper(Looper looper) {
        return new LooperUiThreadUtil(looper);
    }

    public static LooperUiThreadUtil createUsingMainLooper() {
        return new LooperUiThreadUtil(Looper.getMainLooper());
    }

    private LooperUiThreadUtil(Looper looper) {
        this.looper = NullChecker.checkNonNull(looper, "looper cannot be null");
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        if (runnable != null) {
            Handler handler = new Handler(this.looper);
            handler.post(runnable);
        }
    }
}

