/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.helpers;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.File;

public class BitmapEfficiencyHelper {
    public static int calculateSamplingRate(int rawWidth, int rawHeight, int desWidth, int desHeight) {
        boolean scalingIsPossible;
        if (rawWidth < 0 || rawHeight < 0 || desWidth < 0 || desHeight < 0) {
            throw new IllegalArgumentException("all dimensions must be greater than zero");
        }
        boolean bl = scalingIsPossible = rawWidth / 2 >= desWidth && rawHeight / 2 >= desHeight;
        if (scalingIsPossible) {
            return 2 * BitmapEfficiencyHelper.calculateSamplingRate(rawWidth / 2, rawHeight / 2, desWidth, desHeight);
        }
        return 1;
    }

    public static Bitmap decodeResource(Context context, int resId, int desWidth, int desHeight) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (desWidth < 0 || desHeight < 0) {
            throw new IllegalArgumentException("both dimensions must be greater than zero");
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, int desWidth, int desHeight) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be less than zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be less than zero");
        }
        if (desWidth < 0 || desHeight < 0) {
            throw new IllegalArgumentException("both dimensions must be greater than zero");
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeByteArray(byte[] data, int desWidth, int desHeight) {
        return BitmapEfficiencyHelper.decodeByteArray(data, 0, data.length, desWidth, desHeight);
    }

    public static Bitmap decodeFile(File file, int desWidth, int desHeight) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (desWidth < 0 || desHeight < 0) {
            throw new IllegalArgumentException("both dimensions must be greater than zero");
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int rawWidth = options.outWidth;
        int rawHeight = options.outHeight;
        options.inSampleSize = BitmapEfficiencyHelper.calculateSamplingRate(rawWidth, rawHeight, desWidth, desHeight);
        options.inJustDecodeBounds = false;
        options.inScaled = false;
        return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
    }
}

