/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities.library.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class ArrayListWithCallbacks<T>
extends ArrayList<T> {
    private final Collection<OnItemAddedListener> onItemAddedListeners = new HashSet<OnItemAddedListener>();
    private final Collection<OnItemRemovedListener> onItemRemovedListeners = new HashSet<OnItemRemovedListener>();
    private final Collection<OnListClearedListener> onListClearedListeners = new HashSet<OnListClearedListener>();

    public ArrayListWithCallbacks() {
    }

    public ArrayListWithCallbacks(Collection<T> collection) {
        super(collection);
    }

    @Override
    public final boolean add(T object) {
        super.add(object);
        this.callOnItemAddedListeners(object, this.indexOf(object));
        return true;
    }

    @Override
    public final void add(int index, T object) {
        super.add(index, object);
        this.callOnItemAddedListeners(object, index);
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.add(t);
        }
        return true;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends T> collection) {
        int insertionPosition = index;
        for (T t : collection) {
            this.add(insertionPosition, t);
            ++insertionPosition;
        }
        return true;
    }

    @Override
    public final T remove(int index) {
        Object removedItem = super.remove(index);
        this.callOnItemRemovedListeners(removedItem, index);
        return (T)removedItem;
    }

    @Override
    public final boolean remove(Object object) {
        if (this.contains(object)) {
            int index = this.indexOf(object);
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean thisCollectionWasModified = false;
        Iterator thisIterator = this.iterator();
        while (thisIterator.hasNext()) {
            Object nextElementInThis = thisIterator.next();
            if (!collection.contains(nextElementInThis)) continue;
            thisIterator.remove();
            thisCollectionWasModified = true;
        }
        return thisCollectionWasModified;
    }

    @Override
    public final T set(int index, T object) {
        T removedItem = this.remove(index);
        this.add(index, object);
        return removedItem;
    }

    @Override
    public final void clear() {
        super.clear();
        this.callOnListClearedListeners();
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean thisCollectionWasModified = false;
        Iterator thisIterator = this.iterator();
        while (thisIterator.hasNext()) {
            Object nextElementInThis = thisIterator.next();
            if (collection.contains(nextElementInThis)) continue;
            thisIterator.remove();
            thisCollectionWasModified = true;
        }
        return thisCollectionWasModified;
    }

    public final void addOnItemAddedListener(OnItemAddedListener listener) {
        if (listener != null) {
            this.onItemAddedListeners.add(listener);
        }
    }

    public final void addOnItemRemovedListener(OnItemRemovedListener listener) {
        if (listener != null) {
            this.onItemRemovedListeners.add(listener);
        }
    }

    public final void addOnListClearedListener(OnListClearedListener listener) {
        if (listener != null) {
            this.onListClearedListeners.add(listener);
        }
    }

    public final void addOnListChangedListener(OnListChangedListener listener) {
        this.addOnItemAddedListener(listener);
        this.addOnItemRemovedListener(listener);
        this.addOnListClearedListener(listener);
    }

    public final void removeOnItemAddedListener(OnItemAddedListener listener) {
        this.onItemAddedListeners.remove(listener);
    }

    public final void removeOnItemRemovedListener(OnItemRemovedListener listener) {
        this.onItemRemovedListeners.remove(listener);
    }

    public final void removeOnListClearedListener(OnListClearedListener listener) {
        this.onListClearedListeners.remove(listener);
    }

    public final void removeOnListChangedListener(OnListChangedListener listener) {
        this.removeOnItemAddedListener(listener);
        this.removeOnItemRemovedListener(listener);
        this.removeOnListClearedListener(listener);
    }

    private void callOnItemAddedListeners(Object itemAdded, int index) {
        for (OnItemAddedListener l : this.onItemAddedListeners) {
            l.onItemAdded(this, itemAdded, index);
        }
    }

    private void callOnItemRemovedListeners(Object itemRemoved, int index) {
        for (OnItemRemovedListener l : this.onItemRemovedListeners) {
            l.onItemRemoved(this, itemRemoved, index);
        }
    }

    private void callOnListClearedListeners() {
        for (OnListClearedListener l : this.onListClearedListeners) {
            l.onListCleared(this);
        }
    }

    public static interface OnListChangedListener
    extends OnItemAddedListener,
    OnItemRemovedListener,
    OnListClearedListener {
    }

    public static interface OnListClearedListener {
        public void onListCleared(ArrayListWithCallbacks var1);
    }

    public static interface OnItemRemovedListener {
        public void onItemRemoved(ArrayListWithCallbacks var1, Object var2, int var3);
    }

    public static interface OnItemAddedListener {
        public void onItemAdded(ArrayListWithCallbacks var1, Object var2, int var3);
    }
}

