/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.collections;

import com.matthewtamlin.android_utilities_library.collections.Grouper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class KeyBasedGrouper<I, O extends Collection<? super I>>
implements Grouper<I, O> {
    private final Supplier<? extends O> newGroupSupplier;
    private final GroupKeyGenerator<I> groupKeyGenerator;

    public KeyBasedGrouper(Supplier<? extends O> newGroupSupplier, GroupKeyGenerator<I> groupKeyGenerator) {
        if (newGroupSupplier == null) {
            throw new IllegalArgumentException("newGroupSupplier cannot be null");
        }
        if (groupKeyGenerator == null) {
            throw new IllegalArgumentException("groupKeyGenerator cannot be null");
        }
        this.newGroupSupplier = newGroupSupplier;
        this.groupKeyGenerator = groupKeyGenerator;
    }

    @Override
    public Set<O> group(Collection<? extends I> items) {
        HashMap<Object, O> groups = new HashMap<Object, O>();
        for (I libraryItem : items) {
            Object groupKey = this.groupKeyGenerator.getGroupKeyFor(libraryItem);
            if (!groups.containsKey(groupKey)) {
                groups.put(groupKey, this.newGroupSupplier.supplyNewInstance());
            }
            ((Collection)groups.get(groupKey)).add(libraryItem);
        }
        return new HashSet(groups.values());
    }

    public static interface GroupKeyGenerator<T> {
        public Object getGroupKeyFor(T var1);
    }

    public static interface Supplier<T> {
        public T supplyNewInstance();
    }
}

