/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.graphics.Color;

public abstract class ColorHelper {
    public static int blendColors(int color1, int color2, float ratio) {
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be between 0 and 1 (inclusive)");
        }
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }
}

