/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public abstract class ScreenSizeHelper {
    public static ScreenSize getScreenSize(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        Resources res = context.getResources();
        int config = res.getConfiguration().screenLayout & 0xF;
        if (config == 4) {
            return ScreenSize.EXTRA_LARGE;
        }
        if (config == 3) {
            return ScreenSize.LARGE;
        }
        if (config == 2) {
            return ScreenSize.NORMAL;
        }
        if (config == 1) {
            return ScreenSize.SMALL;
        }
        return ScreenSize.UNDEFINED;
    }

    public static boolean screenSizeIsUndefined(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return ScreenSizeHelper.getScreenSize(context) == ScreenSize.UNDEFINED;
    }

    public static boolean screenSizeIsExtraLarge(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return ScreenSizeHelper.getScreenSize(context) == ScreenSize.EXTRA_LARGE;
    }

    public static boolean screenSizeIsLarge(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return ScreenSizeHelper.getScreenSize(context) == ScreenSize.LARGE;
    }

    public static boolean screenSizeIsNormal(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return ScreenSizeHelper.getScreenSize(context) == ScreenSize.NORMAL;
    }

    public static boolean screenSizeIsSmall(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return ScreenSizeHelper.getScreenSize(context) == ScreenSize.SMALL;
    }

    public static int getScreenWidthPx(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public static int getScreenHeightPx(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels;
    }

    public static enum ScreenSize {
        SMALL,
        NORMAL,
        LARGE,
        EXTRA_LARGE,
        UNDEFINED;

    }
}

