/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.content.res.AssetManager;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AssetsHelper {
    private static final String TAG = "[AssetsHelper]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAssetsToDirectory(AssetManager assetManager, String[] assetFiles, File targetDirectory) throws IOException {
        block3: {
            if (assetFiles == null) break block3;
            for (String filename : assetFiles) {
                InputStream fromAssets = null;
                FileOutputStream toTargetDirectory = null;
                try {
                    File outFile = new File(targetDirectory, filename);
                    toTargetDirectory = new FileOutputStream(outFile);
                    fromAssets = assetManager.open(filename);
                    AssetsHelper.copyFile(fromAssets, toTargetDirectory);
                }
                catch (Throwable throwable) {
                    AssetsHelper.closeStream(fromAssets);
                    AssetsHelper.closeStream(toTargetDirectory);
                    throw throwable;
                }
                AssetsHelper.closeStream(fromAssets);
                AssetsHelper.closeStream(toTargetDirectory);
            }
        }
    }

    private static void copyFile(InputStream source, OutputStream target) throws IOException {
        byte[] buffer = new byte[1024];
        int numberOfBytesRead = source.read(buffer);
        while (numberOfBytesRead != -1) {
            target.write(buffer, 0, numberOfBytesRead);
            numberOfBytesRead = source.read(buffer);
        }
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("[Error closing stream] [Stack trace: " + e.getStackTrace() + "]"));
            }
        }
    }
}

