/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.TypedValue;
import com.matthewtamlin.android_utilities_library.R;

public abstract class ColorHelper {
    public static int blendColors(int color1, int color2, float ratio) {
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be between 0 and 1 (inclusive)");
        }
        float a = (float)Color.alpha((int)color1) * ratio + (float)Color.alpha((int)color2) * (1.0f - ratio);
        float r = (float)Color.red((int)color1) * ratio + (float)Color.red((int)color2) * (1.0f - ratio);
        float g = (float)Color.green((int)color1) * ratio + (float)Color.green((int)color2) * (1.0f - ratio);
        float b = (float)Color.blue((int)color1) * ratio + (float)Color.blue((int)color2) * (1.0f - ratio);
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    public static int getPrimaryColor(Context context, int defaultColor) {
        return ColorHelper.getColor(context, defaultColor, R.attr.colorPrimary);
    }

    public static int getPrimaryDarkColor(Context context, int defaultColor) {
        return ColorHelper.getColor(context, defaultColor, R.attr.colorPrimaryDark);
    }

    public static int getAccentColor(Context context, int defaultColor) {
        return ColorHelper.getColor(context, defaultColor, R.attr.colorAccent);
    }

    private static int getColor(Context context, int defaultColor, int colorAttr) {
        TypedValue v = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(v.data, new int[]{colorAttr});
        int color = a.getColor(0, defaultColor);
        a.recycle();
        return color;
    }
}

