/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public final class ScreenSizeHelper {
    private ScreenSizeHelper() {
        throw new UnsupportedOperationException("ScreenSizeHelper cannot be instantiated");
    }

    public static ScreenSize getScreenSize(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        if (config == 4) {
            return ScreenSize.XLARGE;
        }
        if (config == 3) {
            return ScreenSize.LARGE;
        }
        if (config == 2) {
            return ScreenSize.NORMAL;
        }
        if (config == 1) {
            return ScreenSize.SMALL;
        }
        return ScreenSize.UNDEFINED;
    }

    public static boolean screenIsUndefined(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        return config == 0;
    }

    public static boolean screenIsXLarge(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        return config == 4;
    }

    public static boolean screenIsLarge(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        return config == 3;
    }

    public static boolean screenIsNormal(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        return config == 2;
    }

    public static boolean screenIsSmall(Resources res) {
        int config = res.getConfiguration().screenLayout & 0xF;
        return config == 1;
    }

    public static int getScreenWidth(WindowManager windowManager) {
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public static int getScreenHeight(WindowManager windowManager) {
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels;
    }

    public static enum ScreenSize {
        SMALL,
        NORMAL,
        LARGE,
        XLARGE,
        UNDEFINED;

    }
}

