/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.helpers;

import android.content.Context;
import android.support.v4.app.ActivityCompat;

public final class PermissionsHelper {
    private PermissionsHelper() {
        throw new UnsupportedOperationException("PermissionsHelper cannot be instantiated");
    }

    public static boolean permissionsAreGranted(Context context, String[] permissions) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (permissions == null) {
            throw new IllegalArgumentException("permissions cannot be null");
        }
        for (String requiredPermission : permissions) {
            boolean permGranted;
            boolean bl = permGranted = ActivityCompat.checkSelfPermission((Context)context, (String)requiredPermission) == 0;
            if (permGranted) continue;
            return false;
        }
        return true;
    }
}

