/*
 * Decompiled with CFR 0.152.
 */
package com.matthewtamlin.android_utilities_library.collections;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayListWithCallbacks<T>
extends ArrayList<T> {
    private static final String TAG = "[ArrayListWithCallb...]";
    private List<OnItemAddedListener> onItemAddedListeners = new ArrayList<OnItemAddedListener>();
    private List<OnItemRemovedListener> onItemRemovedListeners = new ArrayList<OnItemRemovedListener>();
    private List<OnListClearedListener> onListClearedListeners = new ArrayList<OnListClearedListener>();

    public ArrayListWithCallbacks() {
    }

    public ArrayListWithCallbacks(Collection<T> collection) {
        super(collection);
    }

    @Override
    public boolean add(T object) {
        super.add(object);
        this.callOnItemAddedListeners(object, this.indexOf(object));
        return true;
    }

    @Override
    public void add(int index, T object) {
        super.add(index, object);
        this.callOnItemAddedListeners(object, index);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        int workingIndex = index;
        for (T t : collection) {
            this.add(workingIndex, t);
            ++workingIndex;
        }
        return true;
    }

    @Override
    public T remove(int index) {
        Object removedItem = super.remove(index);
        this.callOnItemRemovedListeners(removedItem, index);
        return (T)removedItem;
    }

    @Override
    public boolean remove(Object object) {
        int potentialIndexOfRemoved = this.indexOf(object);
        if (super.remove(object)) {
            this.callOnItemRemovedListeners(object, potentialIndexOfRemoved);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean thisCollectionWasModified = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object nextElement = i.next();
            if (!collection.contains(nextElement)) continue;
            i.remove();
            thisCollectionWasModified = true;
        }
        return thisCollectionWasModified;
    }

    @Override
    public T set(int index, T object) {
        T removedItem = this.remove(index);
        this.add(index, object);
        return removedItem;
    }

    @Override
    public void clear() {
        super.clear();
        this.callOnListClearedListeners();
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        boolean collectionWasModified = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object nextElementInThis = i.next();
            if (collection.contains(nextElementInThis)) continue;
            i.remove();
            collectionWasModified = true;
        }
        return collectionWasModified;
    }

    public void addOnItemAddedListener(OnItemAddedListener listener) {
        if (listener != null) {
            this.onItemAddedListeners.add(listener);
        }
    }

    public void removeOnItemAddedListener(OnItemAddedListener listener) {
        this.onItemAddedListeners.remove(listener);
    }

    public void addOnItemRemovedListener(OnItemRemovedListener listener) {
        if (listener != null) {
            this.onItemRemovedListeners.add(listener);
        }
    }

    public void removeOnItemRemovedListener(OnItemRemovedListener listener) {
        this.onItemRemovedListeners.remove(listener);
    }

    public void addOnListClearedListener(OnListClearedListener listener) {
        if (listener != null) {
            this.onListClearedListeners.add(listener);
        }
    }

    public void removeOnListClearedListener(OnListClearedListener listener) {
        this.onListClearedListeners.remove(listener);
    }

    private void callOnItemAddedListeners(Object itemAdded, int index) {
        for (OnItemAddedListener l : this.onItemAddedListeners) {
            l.onItemAdded(this, itemAdded, index);
        }
    }

    private void callOnItemRemovedListeners(Object itemRemoved, int index) {
        for (OnItemRemovedListener l : this.onItemRemovedListeners) {
            l.onItemRemoved(this, itemRemoved, index);
        }
    }

    private void callOnListClearedListeners() {
        for (OnListClearedListener l : this.onListClearedListeners) {
            l.onListCleared(this);
        }
    }

    public static interface OnListClearedListener {
        public void onListCleared(ArrayList var1);
    }

    public static interface OnItemRemovedListener {
        public void onItemRemoved(ArrayList var1, Object var2, int var3);
    }

    public static interface OnItemAddedListener {
        public void onItemAdded(ArrayList var1, Object var2, int var3);
    }
}

