/*
 * Decompiled with CFR 0.152.
 */
package com.MaterialToast.lib;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import com.MaterialToast.lib.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/MaterialToast/lib/MaterialToast;", "", "()V", "Companion", "materialtoast_release"})
public final class MaterialToast {
    public static final int PRIMARY = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int DEFAULT = 3;
    public static final int SUCCESS = 4;
    @NotNull
    public static final String SHORT = "short";
    @NotNull
    public static final String LONG = "long";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J(\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/MaterialToast/lib/MaterialToast$Companion;", "", "()V", "DEFAULT", "", "ERROR", "LONG", "", "PRIMARY", "SHORT", "SUCCESS", "WARNING", "customToast", "", "context", "Landroid/content/Context;", "message", "color", "type", "icon", "defaultToast", "show", "mode", "showToast", "materialtoast_release"})
    public static final class Companion {
        public final void show(@NotNull Context context, int mode, @NotNull String message, @NotNull String type) {
            int length;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            boolean shortOption = Intrinsics.areEqual((Object)type, (Object)MaterialToast.SHORT);
            boolean longOption = Intrinsics.areEqual((Object)type, (Object)MaterialToast.LONG);
            if (shortOption || longOption) {
                length = 0;
                if (shortOption) {
                    length = 0;
                }
            } else {
                throw new Throwable("Use MaterialToast.SHORT or MaterialToast.LONG");
            }
            this.showToast(context, mode, message, length);
        }

        private final void showToast(Context context, int mode, String message, int type) {
            switch (mode) {
                case 0: {
                    this.customToast(context, message, R.color.primaryColor, type, R.drawable.ic_info_primary_24dp);
                    break;
                }
                case 2: {
                    this.customToast(context, message, R.color.errorColor, type, R.drawable.ic_error);
                    break;
                }
                case 1: {
                    this.customToast(context, message, R.color.warningColor, type, R.drawable.ic_warning_black_24dp);
                    break;
                }
                case 4: {
                    this.customToast(context, message, R.color.successColor, type, R.drawable.ic_check_success_24dp);
                    break;
                }
                case 3: {
                    this.defaultToast(context, message, type);
                    break;
                }
                default: {
                    this.defaultToast(context, message, type);
                }
            }
        }

        private final void customToast(Context context, String message, int color2, int type, int icon) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)message, (int)type);
            Intrinsics.checkExpressionValueIsNotNull((Object)toast, (String)"Toast.makeText(context, message, type)");
            Toast toast2 = toast;
            View view = toast2.getView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"toast.view");
            View view2 = view;
            Drawable drawable2 = context.getResources().getDrawable(R.drawable.material_toast_background);
            if (drawable2 instanceof ShapeDrawable) {
                Paint paint = ((ShapeDrawable)drawable2).getPaint();
                Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"drawable.paint");
                paint.setColor(ContextCompat.getColor((Context)context, (int)color2));
                view2.setBackground(drawable2);
            } else if (drawable2 instanceof GradientDrawable) {
                ((GradientDrawable)drawable2).setColor(ContextCompat.getColor((Context)context, (int)color2));
                view2.setBackground(drawable2);
            } else if (drawable2 instanceof ColorDrawable) {
                ((ColorDrawable)drawable2).setColor(ContextCompat.getColor((Context)context, (int)color2));
                view2.setBackground(drawable2);
            }
            View view3 = view2.findViewById(16908299);
            if (view3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            TextView textView = (TextView)view3;
            textView.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
            toast2.show();
        }

        private final void defaultToast(Context context, String message, int type) {
            Toast.makeText((Context)context, (CharSequence)message, (int)type).show();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

