/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.bits.Bits;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.state.Int;
import com.mastfrog.graph.BitSetGraph;
import com.mastfrog.graph.BitSetObjectGraph;
import com.mastfrog.graph.BitSetStringGraph;
import com.mastfrog.graph.IntGraphBuilder;
import com.mastfrog.graph.IntGraphVisitor;
import com.mastfrog.graph.IntPath;
import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.graph.PairSet;
import com.mastfrog.graph.StringGraph;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public interface IntGraph {
    public static IntGraph create(BitSet[] reverseReferences, BitSet[] references) {
        return new BitSetGraph(reverseReferences, references);
    }

    public static IntGraph create(Bits[] references) {
        return new BitSetGraph(references);
    }

    public static IntGraph create(BitSet[] references) {
        return new BitSetGraph(references);
    }

    public static IntGraph create(Bits[] reverseReferences, Bits[] references) {
        return new BitSetGraph(reverseReferences, references);
    }

    public static IntGraph load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return BitSetGraph.load((ObjectInput)objectInputStream);
    }

    public static IntGraphBuilder builder() {
        return new IntGraphBuilder();
    }

    public static IntGraphBuilder builder(int expectedSize) {
        return new IntGraphBuilder(expectedSize);
    }

    default public <T> ObjectGraph<T> toObjectGraph(List<T> items) {
        return new BitSetObjectGraph(this, IndexedResolvable.forList(items));
    }

    public boolean abortableBreadthFirstSearch(int var1, boolean var2, IntPredicate var3);

    public boolean abortableDepthFirstSearch(int var1, boolean var2, IntPredicate var3);

    public PairSet allEdges();

    public Bits bottomLevelNodes();

    public void breadthFirstSearch(int var1, boolean var2, IntConsumer var3);

    public int[] byClosureSize();

    public int[] byReverseClosureSize();

    public Bits children(int var1);

    public Bits closureDisjunction(int var1, int var2);

    public Bits closureDisjunction(int ... var1);

    public Bits closureDisjunction(Bits var1);

    public Bits closureOf(int var1);

    public int closureSize(int var1);

    public Bits closureUnion(int var1, int var2);

    public Bits connectors();

    public boolean containsEdge(int var1, int var2);

    public void depthFirstSearch(int var1, boolean var2, IntConsumer var3);

    public Bits disjointNodes();

    public int distance(int var1, int var2);

    public void edges(IntBiConsumer var1);

    default public int edgeCount() {
        Int result = Int.create();
        this.edges((ignoredA, ignoredB) -> result.increment());
        return result.getAsInt();
    }

    public double[] eigenvectorCentrality(int var1, double var2, boolean var4, boolean var5, boolean var6);

    public boolean hasInboundEdge(int var1, int var2);

    public boolean hasOutboundEdge(int var1, int var2);

    public int inboundReferenceCount(int var1);

    public boolean isIndirectlyRecursive(int var1);

    public boolean isReachableFrom(int var1, int var2);

    public boolean isRecursive(int var1);

    public boolean isReverseReachableFrom(int var1, int var2);

    public boolean isUnreferenced(int var1);

    public Bits neighbors(int var1);

    public Bits orphans();

    public int outboundReferenceCount(int var1);

    public double[] pageRank(double var1, double var3, int var5, boolean var6);

    public Bits parents(int var1);

    public List<IntPath> pathsBetween(int var1, int var2);

    public Bits reverseClosureOf(int var1);

    public int reverseClosureSize(int var1);

    public Optional<IntPath> shortestPathBetween(int var1, int var2);

    public PairSet toPairSet();

    public Bits topLevelOrOrphanNodes();

    public int totalCardinality();

    public void walk(IntGraphVisitor var1);

    public void walk(int var1, IntGraphVisitor var2);

    public void walkUpwards(IntGraphVisitor var1);

    public void walkUpwards(int var1, IntGraphVisitor var2);

    public int size();

    public void save(ObjectOutput var1) throws IOException;

    public Optional<IntPath> shortestUndirectedPathBetween(int var1, int var2);

    public List<IntPath> undirectedPathsBetween(int var1, int var2);

    default public StringGraph toStringGraph(String[] sortedNodeNames) {
        return new BitSetStringGraph(this, sortedNodeNames);
    }

    public IntGraph omitting(int ... var1);

    public void diff(IntGraph var1, BiConsumer<IntGraph, IntGraph> var2);

    default public IntPath topologicalSort(BitSet bits) {
        return this.topologicalSort(Bits.fromBitSet((BitSet)bits));
    }

    default public IntPath topologicalSort(final Bits bits) {
        final BitSet visited = new BitSet();
        final IntPath.Builder ipb = IntPath.builder();
        IntConsumer visitPreceding = new IntConsumer(){

            @Override
            public void accept(int node) {
                boolean wasVisited = visited.get(node);
                visited.set(node);
                if (!wasVisited && node > 0 && node < IntGraph.this.size()) {
                    Bits ancestors = IntGraph.this.parents(node);
                    ancestors.forEachSetBitAscending((IntConsumer)this);
                }
                if (!wasVisited && bits.get(node)) {
                    ipb.add(node);
                }
            }
        };
        bits.forEachSetBitAscending(visitPreceding);
        return ipb.build().trim();
    }
}

