/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.bits.Bits;
import com.mastfrog.graph.ObjectPath;
import com.mastfrog.util.preconditions.Checks;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public final class IntPath
implements Comparable<IntPath>,
Iterable<Integer>,
Serializable {
    private static int DEFAULT_SIZE = 12;
    private int[] items;
    private int size;
    private transient BitSet contents;
    private int cachedHashCode = 0;

    IntPath(int size, int[] items) {
        this.size = size;
        this.items = Arrays.copyOf(items, size + DEFAULT_SIZE);
    }

    IntPath(boolean unsafe, int[] items) {
        this(items.length, unsafe, items);
    }

    IntPath(int size, boolean unsafe, int[] items) {
        this.items = unsafe ? items : Arrays.copyOf((int[])Checks.notNull((String)"items", (Object)items), items.length);
        this.size = size;
        if (!unsafe) {
            if (size < items.length) {
                throw new IllegalArgumentException("Size " + size + " is > array length " + items.length);
            }
            for (int i = 0; i < items.length; ++i) {
                if (items[i] >= 0) continue;
                throw new IllegalArgumentException("Negative numbers not allowed");
            }
        }
    }

    IntPath(int initialItems) {
        this.items = new int[initialItems];
    }

    IntPath() {
        this(DEFAULT_SIZE);
    }

    IntPath(Collection<? extends Integer> ints) {
        this.items = new int[ints.size()];
        Iterator<? extends Integer> iter = ints.iterator();
        if (iter instanceof PrimitiveIterator.OfInt) {
            PrimitiveIterator.OfInt pi = (PrimitiveIterator.OfInt)iter;
            int cursor = 0;
            while (pi.hasNext()) {
                this.items[cursor++] = pi.nextInt();
            }
            this.size = cursor;
        } else {
            int cursor = 0;
            while (iter.hasNext()) {
                this.items[cursor++] = (Integer)Checks.notNull((String)("Null at " + (cursor + 1)), (Object)iter.next());
            }
            this.size = cursor;
        }
    }

    IntPath copy() {
        IntPath result = new IntPath(this.size, this.items);
        if (this.contents != null) {
            result.contents = (BitSet)this.contents.clone();
        }
        return result;
    }

    IntPath(String ser) {
        String[] parts = ser.split("\\s*?,\\s*");
        this.items = new int[parts.length];
        int cursor = 0;
        this.contents = new BitSet(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            int val = Integer.parseInt(parts[i]);
            if (val < 0) {
                throw new IllegalArgumentException("Path may not contain negative numbers");
            }
            this.items[cursor++] = val;
            this.contents.set(val);
        }
        this.size = cursor;
    }

    public static IntPath of(Collection<? extends Integer> ints) {
        return new IntPath((Collection)Checks.notNull((String)"ints", ints));
    }

    public static IntPath parse(String val) {
        return new IntPath((String)Checks.notNull((String)"val", (Object)val));
    }

    public IntPath prepending(IntPath other) {
        if (other.isEmpty()) {
            return this.copy();
        }
        int[] nue = Arrays.copyOf(other.items, this.size + other.size());
        System.arraycopy(this.items, 0, nue, other.size, this.size);
        return new IntPath(true, nue);
    }

    public boolean canJoin(IntPath other) {
        return ((IntPath)Checks.notNull((String)"other", (Object)other)).last() == this.first() || other.first() == this.last();
    }

    public IntPath join(IntPath other) {
        return this.join(other, false);
    }

    public int firstOverlappingElement(IntPath other) {
        Bits b;
        if (other == this) {
            return this.isEmpty() ? -1 : 0;
        }
        Bits a = this.toBits();
        if (a.intersects(b = other.toBits())) {
            for (int i = 0; i < this.size; ++i) {
                if (!b.get(this.items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastOverlappingElement(IntPath other) {
        Bits b;
        if (other == this) {
            return this.isEmpty() ? -1 : 0;
        }
        Bits a = this.toBits();
        if (a.intersects(b = other.toBits())) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!b.get(this.items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public IntPath join(IntPath other, boolean eliminateOverlap) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (((IntPath)Checks.notNull((String)"other", (Object)other)).last() == this.first()) {
            IntPath toAppend = this.childPath();
            IntPath appendTo = other;
            if (eliminateOverlap && eliminateOverlap) {
                int index1 = appendTo.firstOverlappingElement(toAppend);
                int index2 = toAppend.lastOverlappingElement(appendTo);
                int deletia1 = appendTo.size() - index1;
                int deletia2 = index2;
                if (deletia1 > 0 && deletia1 >= deletia2) {
                    appendTo = appendTo.subPath(index1, appendTo.size);
                } else if (deletia2 >= 0) {
                    toAppend = toAppend.subPath(0, index2);
                }
            }
            IntPath result = appendTo.append(toAppend);
            if (eliminateOverlap && result.containsRepeatedNodes()) {
                return result.trimmingAtFirstDuplicate();
            }
            return result;
        }
        if (other.first() == this.last()) {
            IntPath toAppend = other.childPath();
            IntPath appendTo = this;
            if (eliminateOverlap) {
                int index1 = appendTo.firstOverlappingElement(toAppend);
                int index2 = toAppend.lastOverlappingElement(appendTo);
                int deletia1 = appendTo.size() - index1;
                int deletia2 = index2;
                if (deletia1 > 0 && deletia1 >= deletia2 && index1 > 0) {
                    appendTo = appendTo.subPath(index1, appendTo.size);
                } else if (deletia2 >= 0 && index2 >= 0) {
                    toAppend = toAppend.subPath(0, index2);
                }
            }
            IntPath result = appendTo.append(toAppend);
            if (eliminateOverlap && result.containsRepeatedNodes()) {
                return result.trimmingAtFirstDuplicate();
            }
            return result;
        }
        return null;
    }

    IntPath trimmingAtFirstDuplicate() {
        block0: for (int i = 0; i < this.size; ++i) {
            int val = this.items[i];
            for (int j = i + 1; j < this.size; ++j) {
                if (this.items[j] != val) continue;
                if (this.size - j > j) {
                    System.arraycopy(this.items, j, this.items, 0, this.size - j);
                    this.size -= j;
                } else {
                    this.size = j;
                }
                this.contents = null;
                continue block0;
            }
        }
        return this;
    }

    public IntPath appending(IntPath other) {
        if (other.isEmpty()) {
            return this.copy();
        }
        int[] nue = Arrays.copyOf(this.items, this.size + other.size());
        System.arraycopy(other.items, 0, nue, this.size, other.size);
        return new IntPath(true, nue);
    }

    public IntPath prepending(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Paths may not contain negative elements: " + value);
        }
        int[] nue = new int[this.size + 1];
        System.arraycopy(this.items, 0, nue, 1, this.items.length);
        nue[0] = value;
        IntPath result = new IntPath(nue.length, nue);
        if (this.contents != null) {
            BitSet newContents = (BitSet)this.contents.clone();
            newContents.set(value);
            result.contents = newContents;
        }
        return result;
    }

    public IntPath appending(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Paths may not contain negative elements: " + value);
        }
        int[] nue = this.items.length > this.size + 1 ? Arrays.copyOf(this.items, this.items.length) : Arrays.copyOf(this.items, this.items.length + 1);
        nue[this.size] = value;
        IntPath result = new IntPath(this.size + 1, true, nue);
        if (this.contents != null) {
            BitSet newContents = (BitSet)this.contents.clone();
            newContents.set(value);
            result.contents = newContents;
        }
        return result;
    }

    public void forEachInt(IntConsumer c) {
        for (int i = 0; i < this.size; ++i) {
            c.accept(this.items[i]);
        }
    }

    public void forEachIntReversed(IntConsumer c) {
        for (int i = this.size - 1; i >= 0; --i) {
            c.accept(this.items[i]);
        }
    }

    public int first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return this.items[0];
    }

    public int last() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("empty");
        }
        return this.items[this.size - 1];
    }

    private void growIfNeeded() {
        if (this.size == this.items.length - 1) {
            this.items = Arrays.copyOf(this.items, this.items.length + DEFAULT_SIZE);
        }
    }

    public static IntPath of(int ... items) {
        return new IntPath(false, items);
    }

    public static IntPath ofUnsafe(int ... items) {
        return new IntPath(false, items);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int first) {
        return new Builder(first);
    }

    public Builder toBuilder() {
        return new Builder(this.copy());
    }

    IntPath addAll(int ... values) {
        if (values.length == 0) {
            return this;
        }
        if (this.size + values.length < this.items.length) {
            this.items = Arrays.copyOf(this.items, this.items.length + values.length);
        }
        System.arraycopy(values, 0, this.items, this.size, values.length);
        this.size += values.length;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath add(int item) {
        this.growIfNeeded();
        this.items[this.size++] = item;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath append(IntPath other) {
        if (other.isEmpty()) {
            return this;
        }
        int targetSize = this.size() + other.size();
        if (this.items.length < targetSize) {
            this.items = Arrays.copyOf(this.items, targetSize);
        }
        System.arraycopy(other.items, 0, this.items, this.size, other.size());
        this.size = targetSize;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath trim() {
        if (this.items.length > this.size) {
            this.items = Arrays.copyOf(this.items, this.size);
        }
        return this;
    }

    public IntPath childPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = new int[this.size - 1];
        System.arraycopy(this.items, 1, nue, 0, nue.length);
        return new IntPath(nue.length, nue);
    }

    public IntPath parentPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = Arrays.copyOf(this.items, this.size - 1);
        return new IntPath(nue.length, true, nue);
    }

    IntPath replaceFrom(int index, IntPath other) {
        this.size = index;
        this.append(other);
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    public IntPath reversed() {
        int[] nue = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nue[i] = this.items[this.size - (i + 1)];
        }
        IntPath result = new IntPath(this.size, nue);
        result.contents = this.contents;
        return result;
    }

    public boolean startsWith(IntPath other) {
        if (other.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.size > this.size) {
            return false;
        }
        int max = Math.min(this.size, other.size);
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(IntPath other) {
        if (other.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.size > this.size) {
            return false;
        }
        int mine = this.size - 1;
        for (int theirs = other.size - 1; mine >= 0 && theirs >= 0; --mine, --theirs) {
            if (this.get(mine) != other.get(theirs)) {
                return false;
            }
            if (mine != 0 || theirs == 0) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(IntPath other) {
        if (Checks.notNull((String)"other", (Object)other) == this) {
            return true;
        }
        return this.toBits().intersects(other.toBits());
    }

    public Bits toBits() {
        if (this.isEmpty()) {
            return Bits.EMPTY;
        }
        return Bits.fromBitSet((BitSet)this.contents());
    }

    public int visitAllSubPaths(int minLength, Consumer<IntPath> c) {
        if (this.size <= Checks.greaterThanZero((String)"minLength", (int)minLength)) {
            return 0;
        }
        int result = 0;
        for (int length = this.size - 1; length >= minLength; --length) {
            for (int start = 0; start < this.size && start + length <= this.size; ++start) {
                c.accept(this.subPath(start, start + length));
                ++result;
            }
        }
        return result;
    }

    public int visitSubPathsOfLength(int length, Consumer<IntPath> c) {
        if (this.size <= Checks.greaterThanZero((String)"minLength", (int)length)) {
            return 0;
        }
        int result = 0;
        for (int start = 0; start < this.size && start + length <= this.size; ++start) {
            c.accept(this.subPath(start, start + length));
            ++result;
        }
        return result;
    }

    public boolean containsRepeatedNodes() {
        return this.toBits().cardinality() < this.size();
    }

    public IntPath subPath(int start, int end) {
        if (start >= this.size || end > this.size) {
            throw new IllegalArgumentException(start + ":" + end + " is out of range 0:" + this.size);
        }
        if (start == 0 && end == this.size) {
            return this;
        }
        if (start > end) {
            throw new IllegalArgumentException("Start > end: " + start + ":" + end);
        }
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("Start or end < 0: " + start + ":" + end);
        }
        if (start == end) {
            return new IntPath(0, true, new int[0]);
        }
        int[] result = new int[end - start];
        System.arraycopy(this.items, start, result, 0, end - start);
        return new IntPath(true, result);
    }

    public int start() {
        return this.size == 0 ? -1 : this.items[0];
    }

    public int end() {
        return this.size == 0 ? -1 : this.items[this.size - 1];
    }

    public boolean contains(IntPath path) {
        int i;
        if (this.isEmpty() || path.isEmpty()) {
            return false;
        }
        if (path == this) {
            return true;
        }
        if (path.size() > this.size) {
            return false;
        }
        if (path.size() == this.size) {
            return path.equals(this);
        }
        BitSet ct = this.contents();
        if (this.endsWith(path)) {
            return true;
        }
        for (i = 0; i < path.size; ++i) {
            if (ct.get(path.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.size - path.size(); ++i) {
            if (!IntPath.arraysEquals(this.items, i, i + path.size(), path.items, 0, path.size())) continue;
            return true;
        }
        return false;
    }

    private BitSet contents() {
        if (this.contents != null) {
            return this.contents;
        }
        BitSet result = new BitSet(this.size);
        for (int i = 0; i < this.items.length; ++i) {
            result.set(this.items[i]);
        }
        return result;
    }

    static boolean arraysEquals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        while (aFromIndex < aToIndex && bFromIndex < bToIndex) {
            if (a[aFromIndex] != b[bFromIndex]) {
                return false;
            }
            ++aFromIndex;
            ++bFromIndex;
        }
        return true;
    }

    public int indexOf(int val) {
        if (!this.contains(val)) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) != val) continue;
            return i;
        }
        throw new AssertionError((Object)"contents bitset out of sync");
    }

    public int indexOf(int from, int val) {
        if (!this.contains(val) || from >= this.size) {
            return -1;
        }
        for (int i = Math.max(0, from); i < this.size; ++i) {
            if (this.get(i) != val) continue;
            return i;
        }
        if (from == 0) {
            throw new AssertionError((Object)"contents bitset out of sync");
        }
        return -1;
    }

    public int lastIndexOf(int from, int val) {
        if (!this.contains(val) || from < 0) {
            return -1;
        }
        for (int i = from; i >= 0; --i) {
            if (this.get(i) != val) continue;
            return i;
        }
        if (from == 0) {
            throw new AssertionError((Object)"contents bitset out of sync");
        }
        return -1;
    }

    public int lastIndexOf(int val) {
        if (!this.contains(val)) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.get(i) != val) continue;
            return i;
        }
        throw new AssertionError((Object)"contents bitset out of sync");
    }

    public boolean contains(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Cannot contain negative values: " + val);
        }
        return this.contents().get(val);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isNotAPath() {
        return this.size() < 2;
    }

    public boolean isEdge() {
        return this.size() == 2;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index + " of " + this.size);
        }
        return this.items[index];
    }

    public int[] items() {
        return this.size == this.items.length ? this.items : Arrays.copyOf(this.items, this.size);
    }

    @Deprecated
    public void iterate(IntConsumer cons) {
        for (int i = 0; i < this.size; ++i) {
            cons.accept(this.get(i));
        }
        cons.accept(-1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof IntPath)) {
            return false;
        }
        IntPath ip = (IntPath)o;
        if (this.size != ip.size || this.hashCode() != ip.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) == ip.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.items[i];
        }
        this.cachedHashCode = result;
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(24);
        for (int i = 0; i < this.size(); ++i) {
            int value = this.get(i);
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public final int sum() {
        int result = 0;
        for (int i = 0; i < this.size; ++i) {
            result += this.items[i];
        }
        return result;
    }

    public <T> ObjectPath<T> toObjectPath(List<T> indexed) {
        return this.toObjectPath(IndexedResolvable.forList(indexed));
    }

    @SafeVarargs
    public final <T extends Comparable<T>> ObjectPath<T> toObjectPath(T ... indexed) {
        return this.toObjectPath(IndexedResolvable.fromArray(indexed));
    }

    public <T> ObjectPath<T> toObjectPath(IndexedResolvable<T> indexed) {
        return new ObjectPath<T>(this, indexed);
    }

    @Override
    public int compareTo(IntPath o) {
        int b;
        int a = this.size();
        return a > (b = o.size()) ? 1 : (a < b ? -1 : 0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IIt();
    }

    public static final class Builder {
        private IntPath result;

        Builder() {
            this.result = new IntPath();
        }

        Builder(int first) {
            this.result = new IntPath();
            this.result.add(first);
        }

        Builder(Builder toCopy) {
            this.result = toCopy.result.copy();
        }

        Builder(IntPath orig) {
            this.result = orig.copy();
        }

        public Builder copy() {
            return new Builder(this.result);
        }

        public Builder add(int val) {
            this.result.add(val);
            return this;
        }

        public Builder add(int ... values) {
            this.result.addAll(values);
            return this;
        }

        public IntPath build() {
            return this.result.copy().trim();
        }

        public Builder prepend(int val) {
            this.result = this.result.prepending(val);
            return this;
        }
    }

    class IIt
    implements Iterator<Integer> {
        int pos = -1;

        IIt() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < IntPath.this.size();
        }

        @Override
        public Integer next() {
            return IntPath.this.get(++this.pos);
        }
    }
}

