/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.bits.Bits;
import com.mastfrog.bits.MutableBits;
import com.mastfrog.bits.collections.BitSetSet;
import com.mastfrog.graph.BitSetGraph;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphVisitor;
import com.mastfrog.graph.IntPath;
import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.graph.ObjectGraphVisitor;
import com.mastfrog.graph.ObjectPath;
import com.mastfrog.graph.algorithm.Algorithm;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import com.mastfrog.graph.algorithm.Score;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;

class BitSetObjectGraph<T>
implements ObjectGraph<T> {
    private final IntGraph graph;
    private final IndexedResolvable<? extends T> indexed;

    BitSetObjectGraph(IntGraph graph, T[] sortedArray) {
        this(graph, new IndexedImpl<T>(sortedArray));
    }

    BitSetObjectGraph(IntGraph graph, IndexedResolvable<? extends T> indexedImpl) {
        this.graph = graph;
        this.indexed = indexedImpl;
    }

    BitSetObjectGraph(BitSetGraph graph, int size, ToIntFunction<Object> toId, IntFunction<T> toObject) {
        this.graph = graph;
        this.indexed = new FIndexed<T>(size, toId, toObject);
    }

    @Override
    public void toIntGraph(BiConsumer<IndexedResolvable<? extends T>, IntGraph> consumer) {
        consumer.accept(this.indexed, this.graph);
    }

    @Override
    public List<ObjectPath<T>> pathsBetween(T a, T b) {
        int aix = this.toNodeId(a);
        int bix = this.toNodeId(b);
        if (aix < 0 || bix < 0) {
            return Collections.emptyList();
        }
        List<IntPath> raw = this.graph.pathsBetween(aix, bix);
        ArrayList<ObjectPath<T>> result = new ArrayList<ObjectPath<T>>(raw.size());
        for (IntPath ip : raw) {
            ObjectPath<? extends T> op = new ObjectPath<T>(ip, this.indexed);
            result.add(op);
        }
        return result;
    }

    static boolean sanityCheckArray(String[] sortedArray) {
        assert (new HashSet<String>(Arrays.asList(sortedArray)).size() == sortedArray.length) : "Array contains duplicates: " + Arrays.toString(sortedArray);
        List<String> a = Arrays.asList(sortedArray);
        ArrayList<String> b = new ArrayList<String>(a);
        Collections.sort(b);
        assert (a.equals(b)) : "Array is not sorted: " + a;
        return true;
    }

    Set<T> toSet(Bits bits) {
        return new BitSetSet(this.indexed, bits);
    }

    Set<T> newSet() {
        return this.toSet((Bits)MutableBits.create((int)this.indexed.size()));
    }

    @Override
    public void save(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.indexed);
        this.graph.save(out);
    }

    static BitSetObjectGraph load(ObjectInput in) throws IOException, ClassNotFoundException {
        int v = in.readInt();
        if (v != 1) {
            throw new IOException("Unsupoorted version " + v);
        }
        String[] sortedArray = (String[])in.readObject();
        BitSetGraph tree = BitSetGraph.load(in);
        return new BitSetObjectGraph<String>((IntGraph)tree, sortedArray);
    }

    @Override
    public void walk(final ObjectGraphVisitor<? super T> v) {
        this.graph.walk(new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetObjectGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetObjectGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public void walk(T start, final ObjectGraphVisitor<? super T> v) {
        int ix = this.toNodeId(start);
        if (ix < 0) {
            return;
        }
        this.graph.walk(ix, new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetObjectGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetObjectGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public void walkUpwards(T start, final ObjectGraphVisitor<? super T> v) {
        int ix = this.toNodeId(start);
        if (ix < 0) {
            return;
        }
        this.graph.walkUpwards(ix, new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetObjectGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetObjectGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public int distance(T a, T b) {
        int ixA = this.toNodeId(a);
        int ixB = this.toNodeId(b);
        if (ixA < 0 || ixB < 0) {
            return Integer.MAX_VALUE;
        }
        return this.graph.distance(ixA, ixB);
    }

    public Set<T> disjointItems() {
        Bits all = this.graph.disjointNodes();
        return new BitSetSet(this.indexed, all);
    }

    public Set<T> disjunctionOfClosureOfMostCentralNodes() {
        List<Score<T>> centrality = this.eigenvectorCentrality();
        double sum = 0.0;
        for (int i = 0; i < centrality.size() / 2; ++i) {
            sum += centrality.get(i).score();
        }
        double avg = sum / (double)(centrality.size() / 2);
        HashSet result = new HashSet(centrality.size());
        centrality.stream().filter(s -> s.score() >= avg).forEach(s -> result.add(s.node()));
        return result;
    }

    @Override
    public Set<T> disjunctionOfClosureOfHighestRankedNodes() {
        double[] items = Algorithm.pageRank().apply(this.graph);
        double sum = 0.0;
        for (int i = 0; i < items.length; ++i) {
            sum += items[i];
        }
        double avg = sum / (double)(items.length / 2);
        MutableBits bits = MutableBits.create((int)this.graph.size());
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] >= avg)) continue;
            bits.set(i);
        }
        return new BitSetSet(this.indexed, (Bits)bits);
    }

    @Override
    public List<Score<T>> eigenvectorCentrality() {
        return this.apply(Algorithm.eigenvectorCentrality());
    }

    @Override
    public List<Score<T>> pageRank() {
        return this.apply(Algorithm.pageRank());
    }

    @Override
    public List<T> byClosureSize() {
        int[] cs = this.graph.byClosureSize();
        ArrayList<T> result = new ArrayList<T>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            result.add(this.toNode(cs[i]));
        }
        return result;
    }

    @Override
    public List<T> byReverseClosureSize() {
        int[] cs = this.graph.byReverseClosureSize();
        ArrayList<T> result = new ArrayList<T>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            result.add(this.toNode(cs[i]));
        }
        return result;
    }

    @Override
    public Set<T> parents(T node) {
        int ix = this.toNodeId(node);
        if (ix == -1) {
            return Collections.emptySet();
        }
        return this.setOf(this.graph.parents(ix));
    }

    @Override
    public Set<T> children(T node) {
        int ix = this.toNodeId(node);
        if (ix == -1) {
            return Collections.emptySet();
        }
        return this.setOf(this.graph.children(ix));
    }

    @Override
    public Set<String> edgeStrings() {
        TreeSet<String> result = new TreeSet<String>();
        this.graph.edges((a, b) -> result.add(this.toNode(a) + ":" + this.toNode(b)));
        return result;
    }

    @Override
    public int toNodeId(T name) {
        int ix = this.indexed.indexOf(name);
        if (ix < 0) {
            return -1;
        }
        return ix;
    }

    @Override
    public T toNode(int index) {
        return (T)this.indexed.forIndex(index);
    }

    private Set<T> setOf(Bits set) {
        return set.isEmpty() ? Collections.emptySet() : this.toSet(set);
    }

    @Override
    public int inboundReferenceCount(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.graph.inboundReferenceCount(ix);
    }

    @Override
    public int outboundReferenceCount(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.graph.outboundReferenceCount(ix);
    }

    @Override
    public Set<T> topLevelOrOrphanNodes() {
        return this.setOf(this.graph.topLevelOrOrphanNodes());
    }

    @Override
    public Set<T> bottomLevelNodes() {
        return this.setOf(this.graph.bottomLevelNodes());
    }

    @Override
    public boolean isUnreferenced(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? true : this.graph.isUnreferenced(ix);
    }

    @Override
    public int closureSize(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.graph.closureSize(ix);
    }

    @Override
    public int reverseClosureSize(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.graph.reverseClosureSize(ix);
    }

    @Override
    public Set<T> reverseClosureOf(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? Collections.emptySet() : this.setOf(this.graph.reverseClosureOf(ix));
    }

    @Override
    public Set<T> closureOf(T node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? Collections.emptySet() : this.setOf(this.graph.closureOf(ix));
    }

    public boolean hasInboundEdge(T from, T to) {
        int f = this.toNodeId(from);
        int t = this.toNodeId(to);
        return f < 0 || t < 0 ? false : this.graph.hasInboundEdge(f, t);
    }

    public boolean hasOutboundEdge(T from, T to) {
        int f = this.toNodeId(from);
        int t = this.toNodeId(to);
        return f < 0 || t < 0 ? false : this.graph.hasOutboundEdge(f, t);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        this.walk((node, depth) -> {
            char[] c = new char[depth * 2];
            Arrays.fill(c, ' ');
            sb.append(c).append(node).append('\n');
        });
        sb.append("Tops:");
        this.topsString(sb);
        sb.append('\n').append("Bottoms: ");
        this.bottomsString(sb);
        return sb.toString();
    }

    private void topsString(StringBuilder into) {
        this.graph.topLevelOrOrphanNodes().forEachSetBitAscending(i -> into.append(' ').append(this.toNode(i)));
    }

    private void bottomsString(StringBuilder into) {
        this.graph.bottomLevelNodes().forEachSetBitAscending(i -> into.append(' ').append(this.toNode(i)));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.graph);
        hash = 79 * hash + this.indexed.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSetObjectGraph other = (BitSetObjectGraph)obj;
        if (!Objects.equals(this.graph, other.graph)) {
            return false;
        }
        return this.indexed.equals(other.indexed);
    }

    @Override
    public List<Score<T>> apply(RankingAlgorithm<?> alg) {
        return alg.apply(this.graph, this::toNode);
    }

    @Override
    public ObjectGraph<T> omitting(Set<T> items) {
        int total = 0;
        int[] indices = new int[items.size()];
        for (T item : items) {
            int ix = this.indexed.indexOf(item);
            if (ix < 0) continue;
            indices[total++] = ix;
        }
        if (total < items.size()) {
            indices = Arrays.copyOf(indices, total);
        }
        ArrayList newItems = new ArrayList(this.indexed.toList());
        newItems.removeAll(items);
        return new BitSetObjectGraph<T>(this.graph.omitting(indices), IndexedResolvable.forList(newItems));
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    static final class FIndexed<T>
    implements IndexedResolvable<T> {
        private final int size;
        private final ToIntFunction<Object> toId;
        private final IntFunction<T> toObject;

        FIndexed(int size, ToIntFunction<Object> toId, IntFunction<T> toObject) {
            this.size = size;
            this.toId = toId;
            this.toObject = toObject;
        }

        public int indexOf(Object o) {
            return this.toId.applyAsInt(o);
        }

        public T forIndex(int index) {
            return this.toObject.apply(index);
        }

        public int size() {
            return this.size;
        }
    }

    static class IndexedImpl<T>
    implements IndexedResolvable<T> {
        private final T[] sortedItems;

        IndexedImpl(T[] sortedItems) {
            this.sortedItems = sortedItems;
        }

        public int indexOf(Object o) {
            return Arrays.binarySearch(this.sortedItems, o);
        }

        public T forIndex(int index) {
            return this.sortedItems[index];
        }

        public int size() {
            return this.sortedItems.length;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.sortedItems);
        }

        public boolean equals(Object o) {
            return o instanceof IndexedImpl && Arrays.equals(((IndexedImpl)o).sortedItems, this.sortedItems);
        }
    }
}

