/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.bits.Bits;
import com.mastfrog.bits.MutableBits;
import com.mastfrog.graph.BitSetGraph;
import com.mastfrog.graph.IntGraph;
import java.util.Arrays;

public final class IntGraphBuilder {
    private MutableBits[] outboundEdges;
    private MutableBits[] inboundEdges;
    private static final int INITIAL_SIZE = 32;
    private int greatestUsed = 0;

    IntGraphBuilder() {
        this(32);
    }

    IntGraphBuilder(int initialSize) {
        this.outboundEdges = new MutableBits[initialSize];
        this.inboundEdges = new MutableBits[initialSize];
        for (int i = 0; i < initialSize; ++i) {
            this.outboundEdges[i] = MutableBits.create((int)initialSize);
            this.inboundEdges[i] = MutableBits.create((int)initialSize);
        }
    }

    private void ensureSize(int newIndex) {
        if (newIndex > this.outboundEdges.length) {
            int newSize = (newIndex / 32 + 1) * 32 + (newIndex % 32 + 1) + 32;
            MutableBits[] newOut = Arrays.copyOf(this.outboundEdges, newSize);
            MutableBits[] newIn = Arrays.copyOf(this.inboundEdges, newSize);
            for (int i = this.greatestUsed; i < newSize; ++i) {
                assert (newIn[i] == null) : "Clobbering in " + i;
                assert (newOut[i] == null) : "Clobbering out " + i;
                newIn[i] = MutableBits.create((int)newSize);
                newOut[i] = MutableBits.create((int)newSize);
            }
            this.outboundEdges = newOut;
            this.inboundEdges = newIn;
        }
        this.greatestUsed = Math.max(this.greatestUsed, newIndex);
    }

    public IntGraphBuilder addEdges(int[][] items) {
        for (int[] edge : items) {
            assert (edge.length == 2) : "sub-array size must be 2 not " + edge.length;
            this.addEdge(edge[0], edge[1]);
        }
        return this;
    }

    public IntGraphBuilder addOrphan(int node) {
        this.ensureSize(node + 1);
        return this;
    }

    public IntGraphBuilder addEdge(int a, int b) {
        this.ensureSize(Math.max(a, b) + 1);
        this.outboundEdges[a].set(b);
        this.inboundEdges[b].set(a);
        return this;
    }

    public IntGraph build() {
        Bits[] ins = new Bits[this.greatestUsed];
        for (int i = 0; i < this.greatestUsed; ++i) {
            ins[i] = this.inboundEdges[i].isEmpty() ? Bits.EMPTY : this.inboundEdges[i].readOnlyView();
        }
        Bits[] outs = new Bits[this.greatestUsed];
        for (int i = 0; i < this.greatestUsed; ++i) {
            outs[i] = this.outboundEdges[i].isEmpty() ? Bits.EMPTY : this.outboundEdges[i].readOnlyView();
        }
        return new BitSetGraph(outs, ins);
    }
}

