/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import java.util.BitSet;
import java.util.function.IntConsumer;

public final class BitSetUtils {
    private BitSetUtils() {
        throw new AssertionError();
    }

    public static BitSet copyOf(BitSet set) {
        BitSet nue = new BitSet(set.size());
        nue.or(set);
        return nue;
    }

    public static void forEach(BitSet set, IntConsumer cons) {
        int bit = set.nextSetBit(0);
        while (bit >= 0) {
            cons.accept(bit);
            bit = set.nextSetBit(bit + 1);
        }
    }

    public static BitSet invert(BitSet set) {
        int last = set.previousSetBit(Integer.MAX_VALUE);
        long[] arr = set.toLongArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        BitSet result = BitSet.valueOf(arr);
        int lastInvertedBit = result.previousSetBit(Integer.MAX_VALUE);
        if (last + 1 <= lastInvertedBit) {
            result.clear(last + 1, lastInvertedBit + 1);
        }
        return result;
    }

    public static BitSet invert(BitSet set, int lastBit) {
        int last = set.previousSetBit(Integer.MAX_VALUE);
        long[] arr = set.toLongArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        BitSet result = BitSet.valueOf(arr);
        if (last + 1 <= lastBit) {
            result.clear(last + 1, lastBit + 1);
        }
        return result;
    }
}

