/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph.dynamic;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.function.throwing.io.IOFunction;
import com.mastfrog.function.throwing.io.IOToIntBiFunction;
import com.mastfrog.function.throwing.io.IOTriConsumer;
import com.mastfrog.graph.BitSetUtils;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.ObjectGraph;
import com.mastfrog.graph.ObjectGraphVisitor;
import com.mastfrog.graph.ObjectPath;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import com.mastfrog.graph.algorithm.Score;
import com.mastfrog.util.preconditions.Checks;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;

public class DynamicGraph<T>
implements ObjectGraph<T> {
    private static int MAGIC = 713732;
    private final Set<T> contents;
    private final List<T> contentsList;
    private final List<BitSet> inboundReferences;
    private final List<BitSet> outboundReferences;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int revision;
    private int hc;
    private ObjectGraph<T> graph;

    public DynamicGraph() {
        this(128);
    }

    private DynamicGraph(LinkedHashSet<T> items, List<BitSet> inbound, List<BitSet> outbound) {
        this.contents = items;
        this.contentsList = new ArrayList<T>(items);
        this.inboundReferences = inbound;
        this.outboundReferences = outbound;
        this.graph = this.createGraph();
    }

    public DynamicGraph(int targetSize) {
        this.contents = new LinkedHashSet<T>(Checks.nonNegative((String)"targetSize", (int)targetSize));
        this.contentsList = new ArrayList<T>(targetSize);
        this.inboundReferences = new ArrayList<BitSet>(targetSize);
        this.outboundReferences = new ArrayList<BitSet>(targetSize);
    }

    @Override
    public void toIntGraph(BiConsumer<IndexedResolvable<? extends T>, IntGraph> consumer) {
        this.graph().toIntGraph(consumer);
    }

    @Override
    public ObjectGraph<T> omitting(Set<T> items) {
        return this.graph().omitting(items);
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    public boolean contains(T item) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.contents.contains(item);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot(BiConsumer<List<T>, List<BitSet>> c) {
        ArrayList<BitSet> bits;
        ArrayList<T> copy;
        this.lock.readLock().lock();
        try {
            copy = new ArrayList<T>(this.contentsList);
            bits = new ArrayList<BitSet>(this.outboundReferences);
        }
        finally {
            this.lock.readLock().unlock();
        }
        c.accept(copy, bits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot(IOTriConsumer<List<T>, List<BitSet>, List<BitSet>> c) throws IOException {
        ArrayList<BitSet> inbound;
        ArrayList<BitSet> outbound;
        ArrayList<T> copy;
        this.lock.readLock().lock();
        try {
            copy = new ArrayList<T>(this.contents);
            outbound = new ArrayList<BitSet>(this.outboundReferences);
            inbound = new ArrayList<BitSet>(this.inboundReferences);
        }
        finally {
            this.lock.readLock().unlock();
        }
        c.apply(copy, outbound, inbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contentsChanged() {
        DynamicGraph dynamicGraph = this;
        synchronized (dynamicGraph) {
            this.graph = null;
            ++this.revision;
        }
    }

    public synchronized int revision() {
        return this.revision;
    }

    private void updateHashCode() {
        this.hc = this.outboundReferences.hashCode() + 73 * this.contentsList.hashCode();
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.contents.clear();
            this.contentsList.clear();
            this.inboundReferences.clear();
            this.outboundReferences.clear();
            this.hc = 0;
        }
        finally {
            this.lock.writeLock().unlock();
            this.contentsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectGraph<T> graph() {
        ObjectGraph<T> graphLocal = this.graph;
        if (graphLocal == null) {
            DynamicGraph dynamicGraph = this;
            synchronized (dynamicGraph) {
                graphLocal = this.graph;
            }
            if (graphLocal == null) {
                graphLocal = this.createGraph();
                dynamicGraph = this;
                synchronized (dynamicGraph) {
                    if (this.graph == null) {
                        this.graph = graphLocal;
                    } else {
                        graphLocal = this.graph;
                    }
                }
            }
        }
        return graphLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOutboundEdges(T item, Set<T> dependencies) {
        this.lock.writeLock().lock();
        boolean changed = false;
        try {
            BitSet inbound;
            int ix;
            ObjectGraph<T> graph = this.graph();
            Set<T> deps = graph.children(item);
            if (deps.equals(dependencies)) {
                boolean bl = false;
                return bl;
            }
            HashSet<T> added = new HashSet<T>(dependencies);
            added.removeAll(deps);
            HashSet<T> removed = new HashSet<T>(deps);
            removed.removeAll(dependencies);
            int pathIndex = this.add(item);
            BitSet outbound = this.outboundReferences.get(pathIndex);
            for (Object dep : removed) {
                ix = this.contentsList.indexOf(dep);
                if (ix < 0) continue;
                changed = true;
                outbound.clear(ix);
                inbound = this.inboundReferences.get(ix);
                inbound.clear(pathIndex);
            }
            for (Object dep : added) {
                ix = this.add(dep);
                outbound.set(ix);
                inbound = this.inboundReferences.get(ix);
                inbound.set(pathIndex);
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
            if (changed) {
                this.contentsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdge(T depender, T dependee) {
        if (Checks.notNull((String)"depender", depender).equals(Checks.notNull((String)"dependee", dependee))) {
            return false;
        }
        if (this.hasEdge(depender, dependee)) {
            return false;
        }
        this.lock.writeLock().lock();
        boolean added = false;
        try {
            added = this._addEdge(depender, dependee);
        }
        finally {
            this.lock.writeLock().unlock();
            if (added) {
                this.contentsChanged();
            }
        }
        return added;
    }

    private boolean _addEdge(T depender, T dependee) {
        assert (this.lock.writeLock().isHeldByCurrentThread()) : "not locked";
        int dependerIndex = this.add(depender);
        int dependeeIndex = this.add(dependee);
        assert (dependerIndex >= 0) : "state inconsistent " + depender + " in " + this.contentsList + " vs " + this.contents;
        assert (dependeeIndex >= 0) : "state inconsistent " + dependee + " in " + this.contentsList + " vs " + this.contents;
        BitSet dependerOutbound = this.outboundReferences.get(dependerIndex);
        BitSet dependeeInbound = this.inboundReferences.get(dependeeIndex);
        boolean result = false;
        if (!dependerOutbound.get(dependeeIndex)) {
            dependerOutbound.set(dependeeIndex);
            result = true;
        }
        if (!dependeeInbound.get(dependerIndex)) {
            dependeeInbound.set(dependerIndex);
            result = true;
        }
        if (result) {
            this.updateHashCode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllReferencesTo(T item) {
        Checks.notNull((String)"item", item);
        this.lock.readLock().lock();
        try {
            if (!this.contents.contains(item)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        boolean changed = false;
        try {
            int bit;
            int itemIndex = this.contentsList.indexOf(item);
            if (itemIndex < 0) {
                boolean bl = false;
                return bl;
            }
            changed = true;
            this.contents.remove(item);
            this.contentsList.remove(itemIndex);
            this.outboundReferences.remove(itemIndex);
            this.inboundReferences.remove(itemIndex);
            for (BitSet set : this.inboundReferences) {
                set.clear(itemIndex);
                bit = set.nextSetBit(itemIndex + 1);
                while (bit >= 0) {
                    set.clear(bit);
                    set.set(bit - 1);
                    bit = set.nextSetBit(bit + 1);
                }
            }
            for (BitSet set : this.outboundReferences) {
                set.clear(itemIndex);
                bit = set.nextSetBit(itemIndex + 1);
                while (bit >= 0) {
                    set.clear(bit);
                    set.set(bit - 1);
                    bit = set.nextSetBit(bit + 1);
                }
            }
            this.updateHashCode();
        }
        finally {
            this.lock.writeLock().unlock();
            if (changed) {
                this.contentsChanged();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEdge(T depender, T dependee) {
        if (Checks.notNull((String)"depender", depender).equals(Checks.notNull((String)"dependee", dependee))) {
            return false;
        }
        if (!this.hasEdge(depender, dependee)) {
            return false;
        }
        this.lock.writeLock().lock();
        boolean changed = false;
        try {
            int dependerIndex = this.contentsList.indexOf(depender);
            int dependeeIndex = this.contentsList.indexOf(dependee);
            if (dependerIndex < 0 || dependeeIndex < 0) {
                boolean bl = false;
                return bl;
            }
            BitSet dependerOutbound = this.outboundReferences.get(dependerIndex);
            BitSet dependeeInbound = this.inboundReferences.get(dependeeIndex);
            boolean bl = changed = dependerOutbound.get(dependeeIndex) || dependeeInbound.get(dependerIndex);
            if (changed) {
                dependerOutbound.clear(dependeeIndex);
                dependeeInbound.clear(dependerIndex);
            }
        }
        finally {
            this.lock.writeLock().unlock();
            if (changed) {
                this.contentsChanged();
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEdge(T depender, T dependee) {
        this.lock.readLock().lock();
        try {
            if (this.contents.contains(depender) && this.contents.contains(dependee)) {
                int dependerIndex = this.contentsList.indexOf(depender);
                int dependeeIndex = this.contentsList.indexOf(dependee);
                assert (dependerIndex >= 0) : "state inconsistent " + depender + " in " + this.contentsList + " vs " + this.contents;
                assert (dependeeIndex >= 0) : "state inconsistent " + dependee + " in " + this.contentsList + " vs " + this.contents;
                BitSet dependerOutbound = this.outboundReferences.get(dependerIndex);
                this.updateHashCode();
                boolean bl = dependerOutbound.get(dependeeIndex);
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    private int add(T path) {
        if (this.contents.add(path)) {
            assert (this.lock.writeLock().isHeldByCurrentThread()) : "not write locked";
            this.inboundReferences.add(new BitSet(this.contents.size()));
            this.outboundReferences.add(new BitSet(this.contents.size()));
            this.contentsList.add(path);
            this.contentsChanged();
            return this.contents.size() - 1;
        }
        return this.contentsList.indexOf(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectGraph<T> createGraph() {
        BitSet[] outbound;
        BitSet[] inbound;
        ArrayList<T> localContents;
        this.lock.readLock().lock();
        try {
            localContents = new ArrayList<T>(this.contents);
            int size = localContents.size();
            inbound = new BitSet[size];
            outbound = new BitSet[size];
            for (int i = 0; i < size; ++i) {
                inbound[i] = BitSetUtils.copyOf(this.inboundReferences.get(i));
                outbound[i] = BitSetUtils.copyOf(this.outboundReferences.get(i));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        assert (inbound.length == localContents.size());
        assert (outbound.length == localContents.size());
        IntGraph ig = IntGraph.create(inbound, outbound);
        ObjectGraph<T> pathGraph = ig.toObjectGraph(Collections.unmodifiableList(localContents));
        return pathGraph;
    }

    @Override
    public List<T> byClosureSize() {
        return this.graph().byClosureSize();
    }

    @Override
    public List<T> byReverseClosureSize() {
        return this.graph().byReverseClosureSize();
    }

    @Override
    public Set<String> edgeStrings() {
        return this.graph().edgeStrings();
    }

    @Override
    public Set<T> parents(T node) {
        return this.graph().parents(node);
    }

    @Override
    public Set<T> children(T node) {
        return this.graph().children(node);
    }

    @Override
    public int inboundReferenceCount(T node) {
        return this.graph().inboundReferenceCount(node);
    }

    @Override
    public int outboundReferenceCount(T node) {
        return this.graph().outboundReferenceCount(node);
    }

    @Override
    public Set<T> topLevelOrOrphanNodes() {
        return this.graph().topLevelOrOrphanNodes();
    }

    @Override
    public Set<T> bottomLevelNodes() {
        return this.graph().bottomLevelNodes();
    }

    @Override
    public boolean isUnreferenced(T node) {
        return this.graph().isUnreferenced(node);
    }

    @Override
    public int closureSize(T node) {
        return this.graph().closureSize(node);
    }

    @Override
    public int reverseClosureSize(T node) {
        return this.graph().reverseClosureSize(node);
    }

    @Override
    public Set<T> reverseClosureOf(T node) {
        return this.graph().reverseClosureOf(node);
    }

    @Override
    public Set<T> closureOf(T node) {
        return this.graph().closureOf(node);
    }

    @Override
    public void walk(ObjectGraphVisitor<? super T> v) {
        this.graph().walk(v);
    }

    @Override
    public void walk(T startingWith, ObjectGraphVisitor<? super T> v) {
        this.graph().walk((T)startingWith, v);
    }

    @Override
    public void walkUpwards(T startingWith, ObjectGraphVisitor<? super T> v) {
        this.graph().walkUpwards((T)startingWith, v);
    }

    @Override
    public int distance(T a, T b) {
        return this.graph().distance(a, b);
    }

    @Override
    public List<Score<T>> eigenvectorCentrality() {
        return this.graph().eigenvectorCentrality();
    }

    @Override
    public List<Score<T>> pageRank() {
        return this.graph().pageRank();
    }

    @Override
    public Set<T> disjunctionOfClosureOfHighestRankedNodes() {
        return this.graph().disjunctionOfClosureOfHighestRankedNodes();
    }

    @Override
    public void save(ObjectOutput out) throws IOException {
        this.graph().save(out);
    }

    @Override
    public int toNodeId(T name) {
        return this.graph().toNodeId(name);
    }

    @Override
    public T toNode(int index) {
        return this.graph().toNode(index);
    }

    @Override
    public List<Score<T>> apply(RankingAlgorithm<?> alg) {
        return this.graph().apply(alg);
    }

    @Override
    public List<ObjectPath<T>> pathsBetween(T a, T b) {
        return this.graph().pathsBetween(a, b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DynamicGraph) {
            DynamicGraph g1 = (DynamicGraph)obj;
            boolean[] result = new boolean[1];
            this.snapshot((List<T> cts1, List<BitSet> items1) -> g1.snapshot((List<T> cts2, List<BitSet> items2) -> {
                result[0] = cts1.equals(cts2) && items1.equals(items2);
            }));
            return result[0];
        }
        return false;
    }

    public int hashCode() {
        return this.hc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.snapshot((List<T> items, List<BitSet> outs) -> {
            int sz = items.size();
            for (int i = 0; i < sz; ++i) {
                Object t = items.get(i);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(t).append(":{");
                BitSet out = (BitSet)outs.get(i);
                BitSetUtils.forEach(out, ix -> sb.append(items.get(ix)).append(','));
                sb.append('}');
            }
        });
        return sb.toString();
    }

    public static <C extends WritableByteChannel & SeekableByteChannel, T> DynamicGraph<T> load(C channel, IOFunction<ByteBuffer, T> func) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        ((SeekableByteChannel)channel).read(buffer);
        buffer.flip();
        int magic = buffer.getInt();
        if (magic != MAGIC) {
            throw new IOException("Invalid magic number, expected " + Integer.toHexString(MAGIC) + " got " + Integer.toHexString(magic));
        }
        int recordSize = buffer.getInt();
        if (recordSize < 0 || recordSize > 0x100000) {
            throw new IOException("Absurdly large size - file probably corrupt: " + recordSize);
        }
        buffer = ByteBuffer.allocate(recordSize);
        int readBytes = ((SeekableByteChannel)channel).read(buffer);
        buffer.flip();
        if (readBytes != recordSize) {
            throw new IOException("Should have read " + recordSize + " bytes but got " + readBytes);
        }
        int recordCount = buffer.getInt();
        if (recordCount < 0 || recordCount > 8192) {
            throw new IOException("Absurd record count " + recordCount + " file is probably corrupted");
        }
        LinkedHashSet<Object> contents = new LinkedHashSet<Object>(recordCount);
        ArrayList<BitSet> inboundReferences = new ArrayList<BitSet>(recordCount);
        ArrayList<BitSet> outboundReferences = new ArrayList<BitSet>(recordCount);
        for (int i = 0; i < recordCount; ++i) {
            Object obj = func.apply((Object)buffer);
            BitSet outs = DynamicGraph.readBitSet(buffer, 65535);
            BitSet ins = DynamicGraph.readBitSet(buffer, 65535);
            contents.add(obj);
            outboundReferences.add(outs);
            inboundReferences.add(ins);
        }
        return new DynamicGraph(contents, inboundReferences, outboundReferences);
    }

    public <C extends WritableByteChannel & SeekableByteChannel> void store(C channel, IOToIntBiFunction<T, C> itemWriter) throws IOException {
        this.snapshot((items, outbound, inbound) -> {
            ByteBuffer numBuffer = ByteBuffer.allocate(4);
            DynamicGraph.writeNumber(MAGIC, channel, numBuffer);
            long sizePosition = ((SeekableByteChannel)channel).position();
            DynamicGraph.writeNumber(0, channel, numBuffer);
            int written = 0;
            int size = items.size();
            written += DynamicGraph.writeNumber(items.size(), channel, numBuffer);
            for (int i = 0; i < size; ++i) {
                written += itemWriter.applyAsInt(items.get(i), (Object)channel);
                BitSet set = (BitSet)outbound.get(i);
                written += DynamicGraph.writeBitSet(set, channel, numBuffer);
                set = (BitSet)inbound.get(i);
                written += DynamicGraph.writeBitSet(set, channel, numBuffer);
            }
            long currPosition = ((SeekableByteChannel)channel).position();
            try {
                ((SeekableByteChannel)channel).position(sizePosition);
                DynamicGraph.writeNumber(written, channel, numBuffer);
            }
            finally {
                ((SeekableByteChannel)channel).position(currPosition);
            }
        });
    }

    private static <T extends WritableByteChannel & SeekableByteChannel> int writeNumber(int num, T channel, ByteBuffer numberBuf) throws IOException {
        numberBuf.putInt(num);
        numberBuf.flip();
        int result = ((SeekableByteChannel)channel).write(numberBuf);
        numberBuf.rewind();
        return result;
    }

    public static BitSet readBitSet(ByteBuffer buffer, int limit) throws IOException {
        int byteCount = buffer.getInt();
        if (byteCount < 0 || byteCount > limit) {
            throw new IOException("Absurd byte count for bitset: " + byteCount + " at " + (buffer.position() - 4));
        }
        byte[] bts = new byte[byteCount];
        buffer.get(bts);
        BitSet outs = BitSet.valueOf(bts);
        return outs;
    }

    public static <C extends WritableByteChannel & SeekableByteChannel> int writeBitSet(BitSet set, C channel, ByteBuffer numBuffer) throws IOException {
        byte[] bts = set.toByteArray();
        int written = DynamicGraph.writeNumber(bts.length, channel, numBuffer);
        if (bts.length > 0) {
            written += ((SeekableByteChannel)channel).write(ByteBuffer.wrap(bts));
        }
        return written;
    }
}

